local drawableSprite = require("structs.drawable_sprite")

local langtonRandomizeBlock = {}
langtonRandomizeBlock.name = "EvaHelper/LangtonRandomizeBlock"
langtonRandomizeBlock.depth = 0
langtonRandomizeBlock.placements = {
	{
		name = "Langton Randomize Block",
		data = {
			width = 16,
			height = 16,
			color = "00D0FF",
			text = "Randomize",
			minLength = 2,
			maxLength = 3
		}
	}
}

langtonRandomizeBlock.fieldInformation = {
	color = {
		fieldType = "color"
	},
	minLength = { fieldType = "integer", minimumValue = 1 },
	maxLength = { fieldType = "integer", minimumValue = 1 },
}

function langtonRandomizeBlock.draw(room, entity)
	
	local r, g, b, a = love.graphics.getColor()
		
	love.graphics.setColor(0.0, 0.0, 0.0, 1.0)
	love.graphics.rectangle("fill", entity.x + 0.5, entity.y + 0.5, entity.width - 1, entity.height - 1)
	love.graphics.setColor(0.5, 0.5, 0.5, 1.0)
	love.graphics.rectangle("line", entity.x + 2.5, entity.y + 2.5, entity.width - 5, entity.height - 5)
	
	-- reset color
	love.graphics.setColor(r, g, b, a)
end

return langtonRandomizeBlock
