local drawableSpriteStruct = require("structs.drawable_sprite")
local helpers = require("mods").requireFromPlugin("helpers")
local consts = require("mods").requireFromPlugin("consts")
local utils = require("utils")

local lift = {}
lift.name = "Portal/Lift"
lift.depth = 0
lift.placements = {
	{
		name = "Portal Lift",
		data = {
			width = 24,
			height = 8,
			dx = 0,
			dy = 0,
			delay = 1,
			speed = 180,
			shadowActivate = true,
			shadowDeactivate = true,
			texture = "Evidence02/objects_portal/track_lift/jumpthruBlue"
		}
	}
}

lift.fieldOrder = { "x", "y", "width", "height", "dx", "dy", "speed", "delay", "texture" }

lift.fieldInformation = {
	dx = { fieldType = "integer" },
	dy = { fieldType = "integer" },
}

function lift.sprite(room, entity)
	local texture = entity.texture
	local x, y = entity.x or 0, entity.y or 0
	local dx, dy = entity.dx or 0, entity.dy or 0
	local width = entity.width or 8

	local startX, startY = math.floor(x / 8) + 1, math.floor(y / 8) + 1
	local stopX = startX + math.floor(width / 8) - 1
	local len = stopX - startX

	local sprites = {}

	for i = 0, len do
		local quadX = i == 0   and 0  or 
					  i == len and 16 or 8
		local sprite = drawableSpriteStruct.fromTexture(texture, entity)
		sprite:setJustification(0, 0)
		sprite:addPosition(i * 8, 0)
		sprite:useRelativeQuad(quadX, 0, 8, 8)
		table.insert(sprites, sprite)
	end

	return sprites
end

function lift.selection(room, entity)
	return utils.rectangle(entity.x, entity.y, entity.width, 8)
end

return lift
