local function dissolve(entity)
  entity.Sprite:Play("diseappear")
end

local function land(entity)
  entity.Sprite:Play("splatter")
  playSound("event:/CC/CC_HollowKnight/SFX/Boss SFX/InfectionImpact",entity.Center)
  entity.Speed = vector2(0, 0)
  entity.Collider = getHitbox(16, 4, 0, -4)
  entity:Add(getEntityTimer(1, dissolve))
  entity:Add(getEntityTimer(2))
end

local function getBlob()
  local blob = getNewBasicAttackActor(puppet.Position, getHitbox(10, 10, 0, -10), "infectedBall", 0.85, 200) --change sprite to that of infection blob
  blob.Sprite:Play("spin")
  blob.Speed = normalize(vector2(0, 1), 150)
  blob:Add(getEntityChecker(
    function ()
      return blob.Grounded
    end, land)
  )
  return blob
end

function onBegin()
  playPuppetAnim("jumpstart")
  playSound("event:/CC/CC_HollowKnight/SFX/Boss SFX/NoskJump",puppet.Center)
  setYSpeed(-700)
  while puppet.Speed.Y < 0 do
    wait()  --wait until it hits the ceiling
  end

  setFlag("nosk_rain", true)
  wait(1)
  for _ = 1, 8 do
    addEntity(getBlob())
    wait(0.5)
  end
  wait(1)
  setFlag("nosk_rain", false)

  setYSpeed(300) --launch to ground
  while not puppet.Grounded do
    wait()
  end
  playPuppetAnim("jumpend")
  playSound("event:/CC/CC_HollowKnight/SFX/Boss SFX/NoskLand",puppet.Center)
  setXSpeed(0)
  wait(0.3)
end