-- NOTES:

-- screen shake > particles > dialogs > temporary decals > dialogs
-- > Reveal dreamer location on map
-- Particles: White particles that eminate from the center and go outwards in a burst

-- NOTES FROM DOC:

-- [on interacting with CC_XELKHK_LORE_RG_A > spawn particles > CC_XELKHK_CUTS_RG_A
-- spawn dreamers in the order: LURIEN MONOMON HERRAH > particles
-- whiteout >  collect custom collectible (dream nail).]



function onBegin()
	wait()
	
	while true do
		wait()
		if getFlag("RGLore") and not getFlag("DreamNailCutscene_Upgrade") then
			-- Cutscene starts
			disableMovement()
			disableRetry()
			player.ForceCameraUpdate = true
			setFlag("RG-02_DeleteCameraTrigger",true)
			player.ForceCameraUpdate = false
			-- Fancy particles and zoom
			coroutine.yield(getLevel():ZoomTo(vector2(180, 80), 1.078, 0.4))
			shake(vector2(168,80),2.5)
			
		
			-- Spawn dreamers
		
			playSound("event:/CC/CC_HollowKnight/SFX/Scene/DreamGhostAppear",player.Position)
			setFlag("RG-02_particles2",true)
			setFlag("DreamNailCutscene_Lurien",true)
			wait(0.3)
			setFlag("RG-02_particles2",false)
			wait(0.5)
			playSound("event:/CC/CC_HollowKnight/SFX/Scene/DreamGhostAppear",player.Position)
			setFlag("RG-02_particles3",true)
			setFlag("DreamNailCutscene_Monomon",true)
			wait(0.3)
			setFlag("RG-02_particles3",false)
			wait(0.5)
			playSound("event:/CC/CC_HollowKnight/SFX/Scene/DreamGhostAppear",player.Position)
			setFlag("RG-02_particles1",true)
			setFlag("DreamNailCutscene_Herrah",true)
			wait(0.3)
			setFlag("RG-02_particles1",false)
			wait(0.5)
			
			say("CC_XELKHK_CUTS_RG_A")
		
			-- Whiteout and collectible
			setFlag("whiteFade",true)
			wait(0.5)
			setFlag("DreamNailCutscene_Lurien",false)
			setFlag("DreamNailCutscene_Monomon",false)
			setFlag("DreamNailCutscene_Herrah",false)
			setFlag("map_Pin_Beast", true)
			setFlag("map_Pin_Watcher", true)
			setFlag("map_Pin_Teacher", true)
			setFlag("map_Pin_Dreamer", false)
			coroutine.yield(getLevel():ZoomAcross(vector2(292,886), 1, 0.2))
			setFlag("whiteFade",false)
			enableMovement()
	        enableRetry()
			setFlag("DreamNailCutscene_Upgrade", true)
		end
	end
end

function onEnd(room, wasSkipped)
	if wasSkipped then
		setFlag("DreamNailCutscene_Lurien",false)
		setFlag("DreamNailCutscene_Monomon",false)
		setFlag("DreamNailCutscene_Herrah",false)
		setFlag("map_Pin_Beast", true)
		setFlag("map_Pin_Watcher", true)
		setFlag("map_Pin_Teacher", true)
		setFlag("map_Pin_Dreamer", false)
		setFlag("RG-02_particles1",false)
		setFlag("RG-02_particles2",false)
		setFlag("RG-02_particles3",false)
	    setFlag("whiteFade",false)
		setFlag("DreamNailCutscene_Upgrade", true)
		getLevel():ResetZoom()
	end
	enableMovement()
	enableRetry()
end