-- NOTES:

-- > ZoomIn to corpse > Dialog

function onBegin()
	if not getFlag("FKcollapse") then -- make sure the cutscene only runs the first time
		disableMovement()
		disableRetry()
		setFlag("FKcollapse",true)
		player.ForceCameraUpdate = true -- makes sure the camera follows the player while falling in StDummy because movement is disabled
		wait(2.5)
		coroutine.yield(getLevel():ZoomTo(vector2(168, 90), 1.2, 2)) -- This is the zoom, the vector2 indicates the coordinates (middle of the screen), the amount, and duration
		-- Coroutine means that the zoom is happening at the same time the next instruction (walking) is happening
		walkTo(2920) -- in world coordinates
		player.Facing = getEnum("Celeste.Facings", "Right") -- in case player doesn't need to walk, makes sure she faces right
		wait(0.35)
		say("CC_XELKHK_FCr_CUTS_A")
		coroutine.yield(getLevel():ZoomBack(0.5)) -- Zooms back to the normal state in x seconds
		wait(0.5)
	end
end

function onEnd(room, wasSkipped)
	if wasSkipped then
		teleportTo(2920,1294) -- in world coordinates
		getLevel():ResetZoom() -- zooms back immediately
	end
	enableMovement()
	enableRetry()
end