local luaCutscenesUtils = require("#Celeste.Mod.MaxHelpingHand.Module.LuaCutscenesUtils")
local mechanic = getEntity("DialogNPC", "Celeste.Mod.DoonvHelper.Entities.")
local codedRefillPotion = getFlag("codeRefillPotion")
local codedTeleporter = getFlag("codeTeleporter")
local codedStrawberry = getFlag("codeStrawberry")
local codedPettableCat = getFlag("codePettableCat")
local gotWrench = getFlag("collectable_wrench")
local greeting = 0
function onBegin()
    disableMovement()
    makeUnskippable()
    disableRetry()
    mechanic.CutsceneModeEnabled = true


    -- GREETING
    -- The mechanic says hi and you start a dialogue
    playSound("event:/CC/CC_KoseiDiamond/ui_pause")

    greeting = math.random(0,2)
    if gotWrench and not getFlag("ellaSeenWrench") then
        setFlag("ellaSeenWrench", true)
        coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_mechanic_foundWrench"))
    elseif not getFlag("canEnterInDungeon") then
        coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_mechanic_debug"))
    elseif getFlag("cryoGoldenRun") then
        coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_mechanic_golden"))
    elseif getFlag("PartyCenter") then
        coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_mechanic_party"))
    else
        if getFlag("weatherRain") then
            if greeting == 0 then
                coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_mechanic_greetingsD"))
            elseif greeting == 1 then
                coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_mechanic_greetingsE"))
            elseif greeting == 2 then
                coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_mechanic_greetingsF"))
            end
        elseif greeting == 0 then
            coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_mechanic_greetings"))
        elseif greeting == 1 then
            coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_mechanic_greetingsB"))
        elseif greeting == 2 then
            coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_mechanic_greetingsC"))
        end
    end

    -- CHOICE 1
    coroutine.yield(luaCutscenesUtils.ChoiceWithDifferentFont("ANDYB", "CC_KoseiDiamond_mechanic_dialogue1_1", "CC_KoseiDiamond_mechanic_dialogue1_2", "CC_KoseiDiamond_mechanic_dialogue1_3"))
    if luaCutscenesUtils.GetChoice() == 1 then -- I'm lost

        if getFlag("Upgrade_SpaceJump") and getFlag("Upgrade_GoldenFeather") then
            coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_mechanic_lost_hell"))
        elseif getFlag("Upgrade_SpaceJump") then
            coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_mechanic_lost_jump"))
        elseif getFlag("Upgrade_GoldenFeather") then
            coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_mechanic_lost_jelly"))
        elseif getFlag("Upgrade_MegaBombs") then
            coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_mechanic_lost_megabomb"))
        elseif getFlag("ellaDungeonDoor") then -- dungeon door is open
            coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_mechanic_dialogue2_1"))
            setFlag("dungeon1coin", true)
            setFlag("dungeon2coin", true)
            setFlag("dungeon3coin", true)
            setFlag("dungeon4coin", true)
            setFlag("dungeon5coin", true)
            setFlag("dungeon6coin", true)
            if not getFlag("Upgrade_Bombs") then
                coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_mechanic_lost_bombsWarn"))
            end
        else -- refill not coded
            coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_mechanic_lost_canOpenR"))
        end

    elseif luaCutscenesUtils.GetChoice() == 2 then -- What's up

        coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_mechanic_dialogue2_2"))

    elseif luaCutscenesUtils.GetChoice() == 3 then -- Code

        coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_mechanic_dialogue2_3"))

        choices = {}
        n = 0
        if not codedRefillPotion then
            choices[n] = "CC_KoseiDiamond_mechanic_dialogue3_1"
            n = n + 1
        end
        choices[n] = "CC_KoseiDiamond_mechanic_dialogue3_2"
        n = n + 1
        if not codedStrawberry then
            choices[n] = "CC_KoseiDiamond_mechanic_dialogue3_3"
            n = n + 1
        end
        choices[n] = "CC_KoseiDiamond_mechanic_dialogue3_4"
        n = n + 1

        if n == 2 then
            coroutine.yield(luaCutscenesUtils.ChoiceWithDifferentFont("ANDYB", choices[0], choices[1]))
        elseif n == 3 then
            coroutine.yield(luaCutscenesUtils.ChoiceWithDifferentFont("ANDYB", choices[0], choices[1], choices[2]))
        else
            coroutine.yield(luaCutscenesUtils.ChoiceWithDifferentFont("ANDYB", choices[0], choices[1], choices[2], choices[3]))
        end

        if choices[luaCutscenesUtils.GetChoice() - 1] == "CC_KoseiDiamond_mechanic_dialogue3_1" then -- Potion
            setFlag("codeRefillPotion",true)
            coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_mechanic_dialogue2_4"))
			setFlag("ellaDungeonDoor",true)
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_mechanic_code_gotPotion"))
            if not getFlag("Upgrade_Bombs") then
                coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_mechanic_lost_bombsWarn"))
            end
        elseif choices[luaCutscenesUtils.GetChoice() - 1] == "CC_KoseiDiamond_mechanic_dialogue3_2" then -- Teleporter
            if not codedTeleporter then
                if getFlag("collectable_mechanickey") then -- successfully codes it
                    setFlag("codeTeleporter",true)
                    playSound("event:/game/general/seed_complete_berry")
                    coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_mechanic_dialogue2_4"))
                else
                    coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_mechanic_dialogue3_2_1"))
                end
            else
                coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_mechanic_dialogue2_5"))
            end
        elseif choices[luaCutscenesUtils.GetChoice() - 1] == "CC_KoseiDiamond_mechanic_dialogue3_3" then -- Strawberry
            if gotWrench then -- successfully codes it
                setFlag("codeStrawberry",true)
                playSound("event:/game/general/seed_complete_berry")
                coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_mechanic_dialogue2_4"))
            else
                coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_mechanic_dialogue3_3_1"))
            end
        elseif choices[luaCutscenesUtils.GetChoice() - 1] == "CC_KoseiDiamond_mechanic_dialogue3_4" then -- Cat
            if not codedPettableCat then -- successfully codes it
                setFlag("codePettableCat",true)
                playSound("event:/CC/CC_KoseiDiamond/cat")
                coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_mechanic_dialogue2_4"))
            else
                coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_mechanic_dialogue2_5"))
            end
        end

    end
    enableMovement()
    enableRetry()
    mechanic.CutsceneModeEnabled = false
end