local luaCutscenesUtils = require("#Celeste.Mod.MaxHelpingHand.Module.LuaCutscenesUtils")
local bettertext = require("#Celeste.Mod.CrossoverCollab.Code.PointsStuff.BetterTextbox")
local save = require("#Celeste.Mod.CrossoverCollab.Code.PointsStuff.PointsModule")
local skeletonmerchant = getEntity("DialogNPC", "Celeste.Mod.DoonvHelper.Entities.")

local statues = {
    "statueA_found", "statueB_found", "statueC_found", "statueD_found", "statueE_found",
    "statueF_found", "statueG_found", "statueH_found", "statueI_found", "statueJ_found",
    "statueK_found", "statueL_found", "statueM_found", "statueN_found", "statueO_found",
    "statueP_found", "statueQ_found", "statueR_found", "statueS_found", "statueT_found"
}
local statueQuestCompleted = getFlag("statueQuestDone")

-- Adds a fish with any name, if that fish already exists, adds that many of it
function AddFish(name, amount)
    save.SaveData:AddFish(name, tonumber(amount))
 end
-- Returns how many fish of that type you have (or coins)
function GetFishamount(name)
    return tonumber(save.SaveData:GetFishAmount(name))
end

function bettersay(dialog)
    coroutine.yield(bettertext.Say(tostring(dialog)))
end

function CountFoundStatues()
    local count = 0
    for _, flag in ipairs(statues) do
        if getFlag(flag) then
            count = count + 1
        end
    end
    return count
end

function onBegin()
	disableMovement()
	makeUnskippable()
	disableRetry()
	skeletonmerchant.CutsceneModeEnabled = true
	
	playSound("event:/CC/CC_KoseiDiamond/ui_pause")
	
	local foundCount = CountFoundStatues()
	
	if foundCount >= 15 and not statueQuestCompleted then
        if foundCount == 20 then
            -- Found all 20 statues
            bettersay("Incredible... You've found *every* statue in the world! Now there is only one way to test if the legend was true... Ready to try dying?")
			bettersay("Just kidding... It's called {~}dark{/~} humor... because we're in the caves.{0.2}{n}...Well{0.1}. Here's one of the things I sell for free.")
            setFlag("statueQuestDone")
			playSound("event:/game/general/seed_complete_berry")
			setFlag("baitPermabuff",true)
			bettersay("The mysterious skeleton has given you a permanent{#f94a4a} bait upgrade!{#} Now fishing has 5% less change to consume baits!")
			wait(0.25)
			playSound("event:/CC/CC_KoseiDiamond_sounds/terracoin")
            if getFlag("Midas") then
                AddFish("terracoins", 500)
                bettersay("Wow! You also received {#F94A4A}500{#} terracoins for your dedication!")
            else
                AddFish("terracoins", 250)
                bettersay("Wow! You also received {#F94A4A}250{#} terracoins for your dedication!")
            end
        else
            -- Found at least 15 but not all 20
            bettersay("Wow, you've found " .. foundCount .. " of the ancient statues! That's quite impressive!")
            playSound("event:/CC/CC_KoseiDiamond_sounds/terracoin")
            setFlag("statueQuestDone")

            if getFlag("Midas") then
                AddFish("terracoins", 200)
                bettersay("You received {#F94A4A}150{#} terracoins for your efforts!")
            else
                AddFish("terracoins", 100)
                bettersay("You received {#F94A4A}100{#} terracoins for your efforts!")
            end
        end

        enableMovement()
        enableRetry()
        skeletonmerchant.CutsceneModeEnabled = false
        endCutscene()
        return
    end

    -- If not enough statues yet, use generic/random greetings
    local greeting = math.random(0, 4)
    if getFlag("cryoGoldenRun") then
        bettersay("Ah, the golden challenger seems far into their challenge. Good luck in these caves.")
    elseif getFlag("PartyCenter") then
        bettersay("Back from the party, eh? Got any souvenirs for me?")
    else
		if not getFlag("skeletonmerchant_firstTime") then
			bettersay("I heard that there are 20 unique statues in world that can make you invincible forever. Touch them and them report back to me if this tale is true.")
			setFlag("skeletonmerchant_firstTime",true)
		else
			if getFlag("statueQuestDone") then
				bettersay("I don't have anything else for you.")
			else
				if greeting == 0 then
					bettersay("Welcome back, traveler. Found any new kinds of statues lately?")
				elseif greeting == 1 then
					bettersay("Hey there! I can hear you. It's not easy to see in the dark, but I have other ways to move around.")
				elseif greeting == 2 then
					bettersay("Good to see you alive. The statues are still waiting out there, you know.")
				elseif greeting == 3 then
					bettersay("The last human I saw was some bearded girl. She bought thousands of special torches for a good price.")
				else
					bettersay("Seems like you still have " .. 20 - foundCount .. " statues left to find.")
				end
			end
		end
    end

    enableMovement()
    enableRetry()
    skeletonmerchant.CutsceneModeEnabled = false
end