local save = require("#Celeste.Mod.CrossoverCollab.Code.PointsStuff.PointsModule")
local bettertext = require("#Celeste.Mod.CrossoverCollab.Code.PointsStuff.BetterTextbox")

--will remove the value [money] from the amount they currently have, all values takes integers
function spendmoney(money)
    save.SaveData:SpendMoney(tonumber(money))
end

--adds the value [money] to their total
function addmoney(money)
    save.SaveData:AddMoney(tonumber(money))
end

--returns a bool, checks if they have more remaining money than the value [money]
function checkmoney(money)
    return save.SaveData:CheckMoney(tonumber(money))
end

--returns the amount of money you have left
function getmoney()
    return save.SaveData:GetMoney()
end

--returns a bool, checks if the value [points] is greter than their total points, example, they have 400 points, if value = 390, it returns true, if value is 410 returns false
function ispointsgreaterthan(points)
    return save.SaveData:CheckPoints(tonumber(points));
end

--returns an int that equals their points
function getpoints()
    return save.SaveData:GetPoints();
end

-- adds points equal to points
function addpoints(points)
    save.SaveData:AddPoints(tonumber(points))
end

-- Adds a flag with the name inside the function
function addflag(flag)
    save.SaveData:AddFlag(flag)
end

-- Returns if a flag exists, if it does, returns true, if it doesn't returns false
function isflagtrue(flag)
    return save.SaveData:IsFlagTrue(flag)
end

-- Removes a flag
function removeflag(flag)
    save.SaveData:RemoveFlag(flag)
end

-- VERY IMPORTANT must be formatted exactly like this ""name" "TEXTUREPATH", float X position, float Y position, float scale X, float scale Y, int depth, string level this is optional, and will efault to the lobby
-- Example of a proper implementatiton addfurniture("catslug", "CC/Lobby/furniture/slugcat", 157, 95, 1, 1, 0)
-- Another example addfurniture("catslug", "CC/Lobby/furniture/slugcat", 157, 95, 1, 1, 0, "CrossoverCollab/1-Submissions/myname")
function addFurniture(name, texturepath, X, Y, scaleX, scaleY, depth, level)
    level = level or ""
    save.SaveData:AddFurniture(name, texturepath, tonumber(X), tonumber(Y), tonumber(scaleX), tonumber(scaleY), tonumber(depth), level)
end

--moves the decal with this name to the X and Y position
function movefurniture(name, X, Y)
    save.SaveData:MoveFurniture(name, tonumber(X), tonumber(Y))
end

--removes the furniture with this name, note removes it entirely, will not register as collected, use showhide() for making it visible
function removefurniture(name)
    save.SaveData:RemoveFurniture(name)
end

-- returns true if a furniture exists with this name
function furniturecheck(name)
    return save.SaveData:FurnitureCheck(name)
end

-- returns whether the furniture with this name is visible
function isfurniturevisible(name)
    return save.SaveData:IsFurnitureVisible(name)
end

-- makes the furniture switch its visibility to the opposite of what it currently is, if its visible makes it not, if its not visible, makes it visible
function furniturecheck(name)
    save.SaveData:ShowHide(name)
end

-- does a spotlight wipe centered on the x and y position
function spotlightWipe(positionX, positionY)
    celeste.SpotlightWipe.FocusPoint = csharpVector2(positionX, positionY)
	getRoom().Wipe = celeste.SpotlightWipe(getRoom(), false, nil)

end

-- Adds a fish with any name, if that fish already exists, adds that many of it, and will add the price to the total for that fish
function AddFish(name, amount, price)
    save.SaveData:AddFish(name, tonumber(amount), tonumber(price))
 end
 
 -- Returns how many fish of that type you have
function GetFishamount(name)
    return tonumber(save.SaveData:GetFishAmount(name))
end

 --  Returns the value of all fish the player has, sell is a boolean that if true will also sell the fish, and name is a string for checking a specific fish, enter "null" for all
function TotalFishValue(sell, name)
    return tonumber(save.SaveData:TotalFishValue(sell, name))
end

--gets the total price of the fish
function GetFishPrice(name)
	return tonumber(SaveData:GetFishPrice(name))
end




function bettersay(dialog)
    coroutine.yield(bettertext.Say(tostring(dialog)))
end
function onTalk()
    if not furniturecheck("catslug") then
        bettersay("[MADELINE distracted left] So..."..tostring(getmoney()))
        addfurniture("catslug", "CC/Lobby/furniture/slugcat", 157, 95, 1, 1, 0)

    else
        addmoney(3)
        removefurniture("catslug")
    end
end
    