local save = require("#Celeste.Mod.CrossoverCollab.Code.PointsStuff.PointsModule")
local bettertext = require("#Celeste.Mod.CrossoverCollab.Code.PointsStuff.BetterTextbox")

-- Adds a flag with the name inside the function
function addflag(flag)
    save.SaveData:AddFlag(flag)
end

-- Returns if a flag exists, if it does, returns true, if it doesn't returns false
function isflagtrue(flag)
    return save.SaveData:IsFlagTrue(flag)
end

-- Removes a flag
function removeflag(flag)
    save.SaveData:RemoveFlag(flag)
end

--adds the value [money] to their total
function addmoney(money)
    save.SaveData:AddMoney(tonumber(money))
end
--returns a bool, checks if they have more remaining money than the value [money]
function checkmoney(money)
    return save.SaveData:CheckMoney(tonumber(money))
end
--returns the amount of money the have left
function getmoney()
    return save.SaveData:GetMoney()
end
--returns a bool, checks if the value [points] is greater than their total points, example, they have 400 points, if value = 390, it returns true, if value is 410 returns false
function checkpoints(points)
    return save.SaveData:CheckPoints(tonumber(points));
end
--returns an int that equals their points
function getpoints()
    return save.SaveData:GetPoints()
end

--removes the furniture with this name
function removefurniture(name)
    save.SaveData:RemoveFurniture(name)
end
-- returns true if a furniture exists with this name
function furniturecheck(name)
    return save.SaveData:FurnitureCheck(name)
end

function bettersay(dialog)
    coroutine.yield(bettertext.Say(tostring(dialog)))
end

local level = getLevel()
local customizeMenuUnlocked = isflagtrue("furniture_bedsheets") or isflagtrue("furniture_courtains") or isflagtrue("furniture_wallpapers")

function onTalk() -- TODO: Add shop menu for customization/buy/nothing. Add customization menu. And ofc, test!

	disableMovement()
	disableRetry()
	makeUnskippable()
	walkTo(2960,false,0.75,false)
	wait(0.08)
	setFlag("shop_anim_notidle_left",true) -- Makes sure to disable the idling left or any other anims
	setFlag("shop_anim_move_left",false)
	player.Facing = getEnum("Celeste.Facings", "Left")
	
	coroutine.yield(engine.Scene:ZoomTo(vector2(1640/8,108), 1.5, 1))
	
	if getFlag("shop_anim_sleeping") then -- if Axi is sleeping (before talking for the first time) he will wake up
		setFlag("shop_anim_wakeup",true)
		setFlag("shop_anim_sleeping",false)
		setFlag("shop_anim_notidle",true) -- Makes sure to disable the idling right
		wait(3)
		setFlag("shop_anim_wakeup",false)
		setFlag("shop_anim_notidle",false)
	end
	
	if isflagtrue("quest_apple") then -- will only play once, if you bring an apple
		say("CC_Lobby_Shop_Quest")
		removeflag("quest_apple")
		addflag("quest_arcadecoupon")
		setFlag("quest_apple",false)
		setFlag("quest_arcadecoupon",true)
		playSound("event:/game/general/assist_nonsolid_out")
		onEnd()
		endCutscene()
	end
	
	if not isflagtrue("shop_firstTime") then -- Shows unique dialog depending on whether you've read the sign.
		if not isflagtrue("shop_readSign") then
			say("CC_Lobby_Shop_Intro")
		else
			say("CC_Lobby_Shop_Intro_Signed")
			setFlag("shop_anim_notidle",true)
			setFlag("shop_anim_leanforward",true)
			wait(1)
			setFlag("shop_anim_leanforward",false)
			setFlag("shop_anim_notidle",false)
			say("CC_Lobby_Shop_Intro_SignedB")
		end
		addflag("shop_firstTime")
		shopBuying()
	elseif not isflagtrue("shop_secondTime") then -- Second presentation.
		say("CC_Lobby_Shop_Intro_Second")
		addflag("shop_secondTime")
		shopBuying()
	end
	shopMainMenu()
end
	
function shopMainMenu()	
	choiceDialog({
	{
	"CC_Lobby_Shop_Buy_Menu_Buy",
	onChosen = function()
		shopBuying()
	end,
	repeatable = true
	},
	{
	"CC_Lobby_Shop_Buy_Menu_Customize",
	onChosen = function()
		shopCustomizing()
	end,
	requires = function()
		return customizeMenuUnlocked == true
	end,
	repeatable = true
	},
	{
	"CC_Lobby_Shop_Buy_Menu_SayHi",
	onChosen = function()
		if not isflagtrue("shop_BuyAndLeaveFirstTime") then -- okay you might wanna take a look at this
			say("CC_Lobby_Shop_Leave")
			addflag("shop_BuyAndLeaveFirstTime")
		else
			say("CC_Lobby_Shop_Buy_ByeB")
		end
		coroutine.yield(engine.Scene:ZoomBack(0.5))
		wait(0.5)
		onEnd()
		endCutscene()
	end
	}
	})
	
	coroutine.yield(engine.Scene:ZoomBack(0.5))
	wait(0.5)
	onEnd()
	endCutscene()
end

function shopBuying()
	-- Shop menu opens here.
	-- Items that were already bought will not be available for purchase
	local boughtItem=false
	choiceDialog({
	{
	"CC_Lobby_Shop_Buy_Nail",
	requires = function()
		return isflagtrue("furniture_nail") == false
	end,
	onChosen = function()
		say("CC_Lobby_Shop_Buy_Nail_Desc")
		local ifBought = shopConfirmation(16,false)
		if ifBought then
			addflag("furniture_nail")
		else
			shopBuying()
		end
	end,
	repeatable = true
	},
	{
	"CC_Lobby_Shop_Buy_MysteryEgg",
	requires = function()
		return isflagtrue("furniture_mysteryegg") == false
	end,
	onChosen = function()
		say("CC_Lobby_Shop_Buy_MysteryEgg_Desc")
		local ifBought = shopConfirmation(6,false)
		if ifBought then
			addflag("furniture_mysteryegg")
		else
			shopBuying()
		end
	end,
	repeatable = true
	},
	{
	"CC_Lobby_Shop_Buy_BulletKin",
	requires = function()
		return isflagtrue("furniture_bulletkin") == false
	end,
	onChosen = function()
		say("CC_Lobby_Shop_Buy_BulletKin_Desc")
		local ifBought = shopConfirmation(12,false)
		if ifBought then
			addflag("furniture_bulletkin")
		else
			shopBuying()
		end
	end,
	repeatable = true
	},
	{
	"CC_Lobby_Shop_Buy_Slugcat",
	requires = function()
		return isflagtrue("furniture_slugcat") == false
	end,
	onChosen = function()
		say("CC_Lobby_Shop_Buy_Slugcat_Desc")
		local ifBought = shopConfirmation(8,false)
		if ifBought then
			addflag("furniture_slugcat")
		else
			shopBuying()
		end
	end,
	repeatable = true
	},
	{
	"CC_Lobby_Shop_Buy_Medamaude",
	requires = function()
		return isflagtrue("furniture_medamaude") == false
	end,
	onChosen = function()
		say("CC_Lobby_Shop_Buy_Medamaude_Desc")
		local ifBought = shopConfirmation(10,false)
		if ifBought then
			addflag("furniture_medamaude")
		else
			shopBuying()
		end
	end,
	repeatable = true
	},
	{
	"CC_Lobby_Shop_Buy_Manipulator",
	requires = function()
		return isflagtrue("furniture_manipulator") == false
	end,
	onChosen = function()
		say("CC_Lobby_Shop_Buy_Manipulator_Desc")
		local ifBought = shopConfirmation(11,false)
		if ifBought then
			addflag("furniture_manipulator")
		else
			shopBuying()
		end
	end,
	repeatable = true
	},
	{
	"CC_Lobby_Shop_Buy_Lute",
	requires = function()
		return isflagtrue("furniture_lute") == false
	end,
	onChosen = function()
		say("CC_Lobby_Shop_Buy_Lute_Desc")
		local ifBought = shopConfirmation(15,false)
		if ifBought then
			addflag("furniture_lute")
		else
			shopBuying()
		end
	end,
	repeatable = true
	},
	{
	"CC_Lobby_Shop_Buy_Pack_BedSheets",
	requires = function()
		return isflagtrue("furniture_bedsheets") == false
	end,
	onChosen = function()
		say("CC_Lobby_Shop_Buy_Pack_BedSheets_Desc")
		local ifBought = shopConfirmation(12,true)
		if ifBought then
			addflag("furniture_bedsheets")
		else
			shopBuying()
		end
	end,
	repeatable = true
	},
	{
	"CC_Lobby_Shop_Buy_Pack_Courtains",
	requires = function()
		return isflagtrue("furniture_courtains") == false
	end,
	onChosen = function()
		say("CC_Lobby_Shop_Buy_Pack_Courtains_Desc")
		local ifBought = shopConfirmation(10,true)
		if ifBought then
			addflag("furniture_courtains")
		else
			shopBuying()
		end
	end,
	repeatable = true
	},
	{
	"CC_Lobby_Shop_Buy_Pack_Wallpapers",
	requires = function()
		return isflagtrue("furniture_wallpapers") == false
	end,
	onChosen = function()
		say("CC_Lobby_Shop_Buy_Pack_Wallpapers_Desc")
		local ifBought = shopConfirmation(20,true)
		if ifBought then
			addflag("furniture_wallpapers")
		else
			shopBuying()
		end
	end,
	repeatable = true
	},
	{
	"CC_Lobby_Shop_Buy_Bye",
	onChosen = function()
		say("CC_Lobby_Shop_Buy_ByeB")
		closeChoiceDialog()
		coroutine.yield(engine.Scene:ZoomBack(0.5))
		wait(0.5)
		onEnd()
		endCutscene()
	end
	}
	})
end


function shopCustomizing() -- This menu allows you to change the themes of bed/courtains/shop wallpapers. It has a nested choiceDialog to avoid making currently active options to appear.
	choiceDialog({
	{
	"CC_Lobby_Shop_Customize_Bed_Selection",
	requires = function()
		return isflagtrue("furniture_bedsheets") == true
	end,
	onChosen = function()
		choiceDialog({
		{
		"CC_Lobby_Shop_Customize_Bed_Default", -- Yellow Squares
		requires = function()
			return (isflagtrue("furniture_bedsheets_theme1") or isflagtrue("furniture_bedsheets_theme2") or isflagtrue("furniture_bedsheets_theme3")) == true
		end,
		onChosen = function()
			removeflag("furniture_bedsheets_theme1")
			removeflag("furniture_bedsheets_theme2")
			removeflag("furniture_bedsheets_theme3")
			say("CC_Lobby_Shop_Customize_Bed_Done")
			say("CC_Lobby_Shop_Buy_AnythingElse")
			shopMainMenu()
		end
		},
		{
		"CC_Lobby_Shop_Customize_Bed_Theme1", -- Candy Swirl With Mint
		requires = function()
			return isflagtrue("furniture_bedsheets_theme1") == false
		end,
		onChosen = function()
			addflag("furniture_bedsheets_theme1")
			removeflag("furniture_bedsheets_theme2")
			removeflag("furniture_bedsheets_theme3")
			say("CC_Lobby_Shop_Customize_Bed_Done")
			say("CC_Lobby_Shop_Buy_AnythingElse")
			shopMainMenu()
		end
		},
		{
		"CC_Lobby_Shop_Customize_Bed_Theme2", -- Pastel
		requires = function()
			return isflagtrue("furniture_bedsheets_theme2") == false
		end,
		onChosen = function()
			addflag("furniture_bedsheets_theme2")
			removeflag("furniture_bedsheets_theme1")
			removeflag("furniture_bedsheets_theme3")
			say("CC_Lobby_Shop_Customize_Bed_Done")
			say("CC_Lobby_Shop_Buy_AnythingElse")
			shopMainMenu()
		end
		},
		{
		"CC_Lobby_Shop_Customize_Bed_Theme3", -- Discrete
		requires = function()
			return isflagtrue("furniture_bedsheets_theme3") == false
		end,
		onChosen = function()
			addflag("furniture_bedsheets_theme3")
			removeflag("furniture_bedsheets_theme1")
			removeflag("furniture_bedsheets_theme2")
			say("CC_Lobby_Shop_Customize_Bed_Done")
			say("CC_Lobby_Shop_Buy_AnythingElse")
			shopMainMenu()
		end
		},
		{
		"CC_Lobby_Shop_Customize_LeaveAsItIs",
		onChosen = function()
			say("CC_Lobby_Shop_Buy_AnythingElseNoCustomization")
			shopMainMenu()
		end
		}
		})
		say("CC_Lobby_Shop_Customize_Bed_Done")
	end
	},
	{
	"CC_Lobby_Shop_Customize_Courtains_Selection",
	requires = function()
		return isflagtrue("furniture_courtains") == true
	end,
	onChosen = function()
		choiceDialog({
		{
		"CC_Lobby_Shop_Customize_Courtains_Default", -- Red
		requires = function()
			return (isflagtrue("furniture_courtains_theme1") or isflagtrue("furniture_courtains_theme2") or isflagtrue("furniture_courtains_theme3")) == true
		end,
		onChosen = function()
			removeflag("furniture_courtains_theme1")
			removeflag("furniture_courtains_theme2")
			removeflag("furniture_courtains_theme3")
			say("CC_Lobby_Shop_Customize_Courtains_Done")
			say("CC_Lobby_Shop_Buy_AnythingElse")
			shopMainMenu()
		end
		},
		{
		"CC_Lobby_Shop_Customize_Courtains_Theme1", -- Blue
		requires = function()
			return isflagtrue("furniture_courtains_theme1") == false
		end,
		onChosen = function()
			addflag("furniture_courtains_theme1")
			removeflag("furniture_courtains_theme2")
			removeflag("furniture_courtains_theme3")
			say("CC_Lobby_Shop_Customize_Courtains_Done")
			say("CC_Lobby_Shop_Buy_AnythingElse")
			shopMainMenu()
		end
		},
		{
		"CC_Lobby_Shop_Customize_Courtains_Theme2", -- Green
		requires = function()
			return isflagtrue("furniture_courtains_theme2") == false
		end,
		onChosen = function()
			addflag("furniture_courtains_theme2")
			removeflag("furniture_courtains_theme1")
			removeflag("furniture_courtains_theme3")
			say("CC_Lobby_Shop_Customize_Courtains_Done")
			say("CC_Lobby_Shop_Buy_AnythingElse")
			shopMainMenu()
		end
		},
		{
		"CC_Lobby_Shop_Customize_Courtains_Theme3", -- Purple
		requires = function()
			return isflagtrue("furniture_courtains_theme3") == false
		end,
		onChosen = function()
			addflag("furniture_courtains_theme3")
			removeflag("furniture_courtains_theme1")
			removeflag("furniture_courtains_theme2")
			say("CC_Lobby_Shop_Customize_Courtains_Done")
			say("CC_Lobby_Shop_Buy_AnythingElse")
			shopMainMenu()
		end
		},
		{
		"CC_Lobby_Shop_Customize_LeaveAsItIs",
		onChosen = function()
			say("CC_Lobby_Shop_Buy_AnythingElseNoCustomization")
			shopMainMenu()
		end
		}
		})
		say("CC_Lobby_Shop_Customize_Courtains_Done")
	end
	},
	{
	"CC_Lobby_Shop_Customize_Wallpapers_Selection",
	requires = function()
		return isflagtrue("furniture_wallpapers") == true
	end,
	onChosen = function()
		choiceDialog({
		{
		"CC_Lobby_Shop_Customize_Wallpapers_Default", -- Wooden Planks
		requires = function()
			return (isflagtrue("furniture_wallpapers_theme1") or isflagtrue("furniture_wallpapers_theme2") or isflagtrue("furniture_wallpapers_theme3") or isflagtrue("furniture_wallpapers_theme4")) == true
		end,
		onChosen = function()
			say("CC_Lobby_Shop_Customize_Wallpapers_Done")
			for i=1,4,1 do
				removeflag("furniture_wallpapers_theme"..tostring(i))
				setFlag("shopTheme"..tostring(i),false)
			end
			shopWorking()
		end
		},
		{
		"CC_Lobby_Shop_Customize_Wallpapers_Theme1", -- Cute
		requires = function()
			return isflagtrue("furniture_wallpapers_theme1") == false
		end,
		onChosen = function()
			say("CC_Lobby_Shop_Customize_Wallpapers_Done")
			addflag("furniture_wallpapers_theme1")
			setFlag("shopTheme1",true)
			for i=2,4,1 do
				removeflag("furniture_wallpapers_theme"..tostring(i))
				setFlag("shopTheme"..tostring(i),false)
			end
			shopWorking()
		end
		},
		{
		"CC_Lobby_Shop_Customize_Wallpapers_Theme2", -- Minty Hearts
		requires = function()
			return isflagtrue("furniture_wallpapers_theme2") == false
		end,
		onChosen = function()
			say("CC_Lobby_Shop_Customize_Wallpapers_Done")
			addflag("furniture_wallpapers_theme2")
			setFlag("shopTheme2",true)
			removeflag("furniture_wallpapers_theme1")
			removeflag("furniture_wallpapers_theme3")
			removeflag("furniture_wallpapers_theme4")
			setFlag("shopTheme1",false)
			setFlag("shopTheme3",false)
			setFlag("shopTheme4",false)
			shopWorking()
		end
		},
		{
		"CC_Lobby_Shop_Customize_Wallpapers_Theme3", -- Refreshing
		requires = function()
			return isflagtrue("furniture_wallpapers_theme3") == false
		end,
		onChosen = function()
			say("CC_Lobby_Shop_Customize_Wallpapers_Done")
			addflag("furniture_wallpapers_theme3")
			setFlag("shopTheme3",true)
			removeflag("furniture_wallpapers_theme1")
			removeflag("furniture_wallpapers_theme2")
			removeflag("furniture_wallpapers_theme4")
			setFlag("shopTheme1",false)
			setFlag("shopTheme2",false)
			setFlag("shopTheme4",false)
			shopWorking()
		end
		},
		{
		"CC_Lobby_Shop_Customize_Wallpapers_Theme4", -- Cosmic
		requires = function()
			return isflagtrue("furniture_wallpapers_theme4") == false
		end,
		onChosen = function()
			say("CC_Lobby_Shop_Customize_Wallpapers_Done")
			addflag("furniture_wallpapers_theme4")
			setFlag("shopTheme4",true)
			for i=1,3,1 do
				removeflag("furniture_wallpapers_theme"..tostring(i))
				setFlag("shopTheme"..tostring(i),false)
			end
			shopWorking()
		end
		},
		{
		"CC_Lobby_Shop_Customize_LeaveAsItIs",
		onChosen = function()
			say("CC_Lobby_Shop_Buy_AnythingElseNoCustomization")
			shopMainMenu()
		end
		}
		})
		setFlag("shop_anim_notidle",true)
		setFlag("shop_anim_lookaround",true)
		wait(2.5)
		setFlag("shop_anim_notidle",false)
		setFlag("shop_anim_lookaround",false)
		say("CC_Lobby_Shop_Customize_Wallpapers_Done")
	end
	},
	{
	"CC_Lobby_Shop_Customize_Nothing",
	onChosen = function()
		say("CC_Lobby_Shop_Buy_AnythingElse")
		shopMainMenu()
	end
	}
	})
end

function shopWorking() -- blackout cutscene that plays while wallpapers are being changed
	setFlag("shopWorking",true)
	wait(0.15)
	playSound("event:/CC/CC_Lobby/CC_hammer")
	wait(1.2)
	setFlag("shopWorking",false)
	wait(0.15)
	setFlag("shop_anim_lookaround",true)
	setFlag("shop_anim_notidle",true)
	wait(2.5)
	setFlag("shop_anim_lookaround",false)
	setFlag("shop_anim_notidle",false)
	say("CC_Lobby_Shop_Customize_Wallpapers_Done_Post")
	shopMainMenu()
end

function shopConfirmation(price,isPack) -- This function is given a price and returns true if the player buys the item
	bettersay("[AXI left normal]We've got this listed at... {#F94A4A}"..tostring(price).."G{#} and you have {#F94A4A}"..tostring(getmoney()).."G{#}... Is this what you're looking for?")
	if choice("CC_Lobby_Shop_Buy_YesPlease", "CC_Lobby_Shop_Buy_NoThankYou") == 1 then
		if checkmoney(price) then -- Does the player have enough money?
			if isPack == false then
				say("CC_Lobby_Shop_Buy_ThankYou")
			else
				say("CC_Lobby_Shop_Buy_ThankYouPack")
			end
			addmoney(price*-1)
			playSound("event:/CC/CC_Lobby/CC_money")
			return true
		else
			bettersay("[AXI left interested]It's {#F94A4A}"..tostring(price).."G...{#}{0.2}[AXI left smile]{n}Tad bit much for your budget, ey?{0.2} [AXI left normal]This is as much as we offer this for. Why not get some {#F94A4A}G{#}?")
			
		end
	else
		say("CC_Lobby_Shop_Buy_AnythingElse")
		return false
	end
end


function onEnd()
	enableMovement()
	enableRetry()
	if isflagtrue("shop_firstTime") then -- if not sleeping, then resets animation
		setFlag("shop_anim_notidle",false)
	else -- if sleeping, keeps sleeping
		setFlag("shop_anim_notidle",true)
		setFlag("shop_anim_sleeping",true)
	end
	setFlag("shop_anim_lookaround",false)
	setFlag("shop_anim_move",false)
	setFlag("shop_anim_wakeup",false)
	setFlag("shop_anim_leanforward",false)
	setFlag("shopWorking",false)
	engine.Scene:ResetZoom()
end