local luaCutscenesUtils = require("#Celeste.Mod.MaxHelpingHand.Module.LuaCutscenesUtils")
local lua_helper = celeste.Mod.LuaCutscenes.LuaHelper

local function makeCoroutine(func)
	return monocle.Coroutine(lua_helper.LuaCoroutineToIEnumerator(coroutine.create(func)))
end

local function mariAppears()
	wait(0.5)
	getLevel().InCutscene = true
	player.Facing = getEnum("Celeste.Facings", "Right")
	setFlag("mariEndIdle",true)
end

function onTalk()
    disableMovement()
	getLevel().InCutscene = false
	setFlag("bookRead6",true)
	talker:Add(makeCoroutine(mariAppears))
	coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("OMORI_GAME", "CC_omori_library05"))
	playMusic("event:/none")
	coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("OMORI_GAME", "CC_omori_library05b"))
	setFlag("mariEndIdle",false)
	setFlag("mariEndWalk",true)
	wait(2.6)
end

function onEnd()
    enableMovement()
	setFlag("mariEndIdle",false)
	setFlag("mariEndWalk",false)
	getLevel().InCutscene = false
end