local drawableSprite = require("structs.drawable_sprite")
local utils = require("utils")


local dashSwitchHorizontal = {}

dashSwitchHorizontal.name = "IsaSMB/TimeSwitch"
dashSwitchHorizontal.depth = 0
dashSwitchHorizontal.justification = {0.5, 0.5}
dashSwitchHorizontal.fieldInformation = {
    side = {
        options = {
            "Up",
            "Down",
            "Left",
            "Right",
        }
    },
    type = {
        options = { 
			"Rewind",
			"Backwards",
			"Stopped",
			"Playing",
			"FastForward"
        }
    }
}
dashSwitchHorizontal.placements = { }

local placementsInfo = {
    {dashSwitchHorizontal.placements, "Up"},
    {dashSwitchHorizontal.placements, "Down"},
    {dashSwitchHorizontal.placements, "Left"},
    {dashSwitchHorizontal.placements, "Right"}
}

for _, info in ipairs(placementsInfo) do
    local placementsTable, key = unpack(info)
    local placement = {
        name = key,
        data = {
            side = key,
            type = "Playing",
            cycle = "base"
        }
    }

    table.insert(placementsTable, placement)
end

function dashSwitchHorizontal.sprite(room, entity)
    local leftSide = entity.side
    local sprite = drawableSprite.fromTexture("objects/temple/dashButtonMirror00", entity)

    if leftSide == "Left" then
        sprite:addPosition(0, 8)
        sprite.rotation = math.pi
    elseif leftSide == "Right" then
        sprite:addPosition(8, 8)
        sprite.rotation = 0
    elseif leftSide == "Up" then
        sprite:addPosition(8, 0)
        sprite.rotation = -math.pi / 2
    elseif leftSide == "Down" then
        sprite:addPosition(8, 8)
        sprite.rotation = math.pi / 2
    end

    return sprite
end

return {
    dashSwitchHorizontal
}