local drawableSpriteStruct = require("structs.drawable_sprite")
local trackSpinner = {}

local nodeAlpha = 0.3
local dustEdgeColor = {1.0, 0.0, 0.0}

trackSpinner.name = "IsaSMB/TrackSpinner"
trackSpinner.nodeLimits = {1, 1000}
trackSpinner.nodeLineRenderType = "line"
trackSpinner.depth = -50
trackSpinner.fieldInformation = {
    sprite = {
        options = {
            "blade",
            "dust",
            "star"
        }
    },
}
trackSpinner.placements = {
    {
        name = "default",
        data = {
            cycle = "base",
            sprite = "blade",
            offset = 0,
            moveTime = 0.9,
            stopTime = 0.1,
            localSpeed = 1,
            looped = false,
        }
    },
    {
        name = "dust",
        data = {
            cycle = "base",
            sprite = "dust",
            offset = 0,
            moveTime = 0.9,
            stopTime = 0.1,
            localSpeed = 1,
            looped = false,
        }
    },
    {
        name = "star",
        data = {
            cycle = "base",
            sprite = "star",
            offset = 0,
            moveTime = 0.9,
            stopTime = 0.1,
            localSpeed = 1,
            looped = false,
        }
    }
}

local function getSprite(room, entity, alpha)
    local sprites = {}

    local spriteID = entity.sprite

    if spriteID == "star" then
        local starfishTexture = "danger/starfish13"

        table.insert(sprites, drawableSpriteStruct.fromTexture(starfishTexture, entity))

    elseif spriteID == "dust" then
        local dustBaseTexture = "danger/dustcreature/base00"
        local dustBaseOutlineTexture = "dust_creature_outlines/base00"
        local dustBaseSprite = drawableSpriteStruct.fromTexture(dustBaseTexture, entity)
        local dustBaseOutlineSprite = drawableSpriteStruct.fromInternalTexture(dustBaseOutlineTexture, entity)

        dustBaseOutlineSprite:setColor(dustEdgeColor)

        table.insert(sprites, dustBaseOutlineSprite)
        table.insert(sprites, dustBaseSprite)

    else
        local bladeTexture = "danger/blade00"

        table.insert(sprites, drawableSpriteStruct.fromTexture(bladeTexture, entity))
    end

    if alpha then
        for _, sprite in ipairs(sprites) do
            sprite:setAlpha(alpha)
        end
    end

    return sprites
end

function trackSpinner.sprite(room, entity)
    return getSprite(room, entity)
end

function trackSpinner.nodeSprite(room, entity, node)
    local entityCopy = table.shallowcopy(entity)

    entityCopy.x = node.x
    entityCopy.y = node.y

    return getSprite(room, entityCopy, nodeAlpha)
end

return trackSpinner