local utils = require("utils")
local entity_version = 2

local colorGradient = function(pos, gradient, saturation)
    if pos <= gradient[1].pos then
        return {
            gradient[1].color.r / 255,
            gradient[1].color.g / 255,
            gradient[1].color.b / 255,
        }
    end

    for i = 1, #gradient-1 do
        if pos >= gradient[i].pos and pos <= gradient[i+1].pos then
            local progress = (pos - gradient[i].pos) / (gradient[i+1].pos - gradient[i].pos)
            return {
                ((1-progress)*(gradient[i].color.r / 255)^saturation + progress*(gradient[i+1].color.r / 255)^saturation)^(1/saturation),
                ((1-progress)*(gradient[i].color.g / 255)^saturation + progress*(gradient[i+1].color.g / 255)^saturation)^(1/saturation),
                ((1-progress)*(gradient[i].color.b / 255)^saturation + progress*(gradient[i+1].color.b / 255)^saturation)^(1/saturation),
            }
        end
    end

    return {
        gradient[#gradient].color.r / 255,
        gradient[#gradient].color.g / 255,
        gradient[#gradient].color.b / 255,
    }
end

local basketball = {
    name = "Frigohelper/Basketball",
    depth = 43,
    justification = {0.5,1},
    placements = {
        {
            name = "basketball",
            data = {
                version = entity_version,
                noGravity = false,
                yeetingPower = 0.0,
            }
        },
        {
            name = "chargedbasketball",
            data = {
                version = entity_version,
                noGravity = false,
                yeetingPower = 0.5,
            }
        },
        {
            name = "binglebasketball",
            data = {
                version = entity_version,
                noGravity = false,
                yeetingPower = 1.0,
            }
        },
        {
            name = "spacebasketball",
            data = {
                version = entity_version,
                noGravity = true,
                yeetingPower = 0.5,
            }
        },
    },
    fieldOrder = {
        "x", "y",
        "yeetingPower",
        "customColor",
        "noGravity",
        "useCustomColor",
    },
    ignoredFields = {
        "_name", "_id", "originX", "originY",
        "version",
    },
    fieldInformation = {
        useCustomColor = {
            default = false,
        },
        customColor = {
            fieldType = "color",
            default = "000000",
        },
    },
    texture = function (room, entity)
        return "objects/FrigoHelper/basketball/"..(entity.noGravity and "weespace00" or "wee00")
    end,
    color = function(room, entity)
        ---[[
        if entity.useCustomColor and entity.customColor then
            return utils.getColor(entity.customColor)
        end
        --]]

        local x = entity.yeetingPower
        local gradient = {
            {pos = -2.5, color = {r =  30, g =  30, b =  30}},
            {pos = -0.5, color = {r = 244, g =  50, b =  11}},
            {pos =  0.0, color = {r = 255, g = 127, b =  39}},
            {pos =  1/8, color = {r = 203, g = 252, b =  68}},
            {pos =  1/4, color = {r =  71, g = 169, b = 255}},
            {pos =  0.5, color = {r =  71, g =  74, b = 255}},
            {pos =  1.0, color = {r = 255, g =  60, b = 255}},
            {pos =  2.5, color = {r = 255, g = 255, b = 255}},
        }
        return colorGradient(x, gradient, 2.5)
        --[[
        local l0 = (x-0.5)*(x-1)/0.5
        local l1 = -x*(x-1)/0.25
        local l2 = x*(x-0.5)/0.5
        return {
            math.log(math.exp(255/255)*l0 + math.exp(71/255)*l1 + math.exp(255/255)*l2),
            math.log(math.exp(127/255)*l0 + math.exp(74/255)*l1 + math.exp(60/255)*l2),
            math.log(math.exp(39/255)*l0 + math.exp(255/255)*l1 + math.exp(255/255)*l2),

            --2.88627*x^2 - 2.88627*x + 1,
            --0.498039 - 0.568627*x + 0.305882*x^2,
            --0.152941 + 2.54118*x - 1.69412*x^2,
        }
        --]]
    end,
}

return basketball