module DoomCelesteDoomEntity

using ..Ahorn, Maple

@mapdef Entity "DoomCeleste/DoomEntity" DoomEntity(
    x::Integer, y::Integer,
    sampleProperty::Integer=0
)

const placements = Ahorn.PlacementDict(
    "Doom Entity (DoomCeleste)" => Ahorn.EntityPlacement(
        DoomEntity,
    )
)

sprite = "objects/DoomCeleste/doomEntity/idle00"

function Ahorn.selection(entity::DoomEntity)
    x, y = Ahorn.position(entity)
    return Ahorn.getSpriteRectangle(sprite, x, y)
end

Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::DoomEntity, room::Maple.Room) = Ahorn.drawSprite(ct, sprite, 0, 0)

end