local Audio = require("#celeste.audio")
local monocle = require("#monocle")
local coroutineEntity = monocle.Entity()

function onBegin()
  local level = getLevel()
  level:add(coroutineEntity)
  disableRetry()
  disableMovement()
  waitUntilOnGround()
  coroutineEntity:add(monocle.Coroutine(celeste.CutsceneEntity.CameraTo(vector2(120, 0), 1)))
  coroutineEntity:add(monocle.Coroutine(level:ZoomTo(vector2(160, 110), 1.33, 1)))
  player.Facing = getEnum("Celeste.Facings", "Right")
  walkTo(266, false, 1.2)
  wait(0.5)
  setFlag("nemesis_get", true)
  celeste.Audio.Play('event:/game/general/wall_break_stone', player.Position)
  shake(0.2)
  celeste.Audio.Play('event:/game/general/secret_revealed', player.Position)
  wait(0.2)
  setFlag("nemesis_got", true)
  wait(1)
  setFlag("nemesis_got", false)
  wait(0.33)
  celeste.Audio.Play('event:/game/general/assist_nonsolid_in', player.Position)
  setFlag("guneline_activated", true)
  coroutineEntity:add(monocle.Coroutine(level:ZoomAcross(vector2(160, 90), 1, 0.5)))
  enableRetry()
  enableMovement()
end