module TBCGravityFallingBlock

using ..Ahorn, Maple

@mapdef Entity "ChronoHelper/GravityFallingBlock" GravityFallingBlock(x::Integer, y::Integer, width::Integer=Maple.defaultBlockWidth, height::Integer=Maple.defaultBlockHeight,
    tiletype::String="3", climbFall::Bool=true, behind::Bool=false, instantFall::Bool=false)

const placements = Ahorn.PlacementDict(
    "Gravity Falling Block (Chrono Helper)" => Ahorn.EntityPlacement(
        GravityFallingBlock,
        "rectangle",
        Dict{String, Any}(),
        Ahorn.tileEntityFinalizer
    ),
)

Ahorn.editingOptions(entity::GravityFallingBlock) = Dict{String, Any}(
    "tiletype" => Ahorn.tiletypeEditingOptions()
)

Ahorn.minimumSize(entity::GravityFallingBlock) = 8, 8
Ahorn.resizable(entity::GravityFallingBlock) = true, true

Ahorn.selection(entity::GravityFallingBlock) = Ahorn.getEntityRectangle(entity)

Ahorn.renderAbs(ctx::Ahorn.Cairo.CairoContext, entity::GravityFallingBlock, room::Maple.Room) = Ahorn.drawTileEntity(ctx, room, entity)

end