module TBCGravityFallingBlockSwitch

using ..Ahorn, Maple

@mapdef Entity "ChronoHelper/GravityFallingBlockSwitch" GravityFallingBlockSwitch(x::Integer, y::Integer, gravityType::Integer=0)

const placements = Ahorn.PlacementDict(
    "Gravity Falling Block Switch (Chrono Helper, Toggle)" => Ahorn.EntityPlacement(
        GravityFallingBlockSwitch,
        "point",
        Dict{String, Any}(
            "gravityType" => 0,
        )
    ),
    "Gravity Falling Block Switch (Chrono Helper, Up)" => Ahorn.EntityPlacement(
        GravityFallingBlockSwitch,
        "point",
        Dict{String, Any}(
            "gravityType" => 1,
        )
    ),
    "Gravity Falling Block Switch (Chrono Helper, Down)" => Ahorn.EntityPlacement(
        GravityFallingBlockSwitch,
        "point",
        Dict{String, Any}(
            "gravityType" => 2,
        )
    )
)

const gravityTypes = Dict{String, Integer}(
    "Toggle" => 0,
    "Up" => 1,
    "Down" => 2,
)

Ahorn.editingOptions(entity::GravityFallingBlockSwitch) = Dict{String, Any}( "gravityType" => gravityTypes )

function Ahorn.selection(entity::GravityFallingBlockSwitch)
    x, y = Ahorn.position(entity)

    return Ahorn.Rectangle(x-9, y-9, 18, 18)
end

function getSprite(entity::GravityFallingBlockSwitch)
    type = get(entity.data, "gravityType", 0)

    if type == 0
        return "objects/chronohelper/gravityFallingBlockSwitch/switch07.png"
    elseif type == 1
        return "objects/chronohelper/gravityFallingBlockSwitch/switch00.png"
    else
        return "objects/chronohelper/gravityFallingBlockSwitch/switch11.png"
    end
end

function Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::GravityFallingBlockSwitch, room::Maple.Room) 
    Ahorn.drawSprite(ctx, getSprite(entity), 0,0)
end
end