module BSSStaticDebrisDashBlock
using ..Ahorn, Maple

@mapdef Entity "ChronoHelper/StaticDebrisDashBlock" StaticDebrisDashBlock(x::Integer, y::Integer,
width::Integer=8, height::Integer=8, tiletype::String="3",
blendin::Bool=true, canDash::Bool=true, permanent::Bool=true, attachEntities::Bool=false, makeStatic::Bool = true
)

const placements = Ahorn.PlacementDict(
    "Static Debris Dash Block (Chrono Helper)" => Ahorn.EntityPlacement(
        StaticDebrisDashBlock,
        "rectangle",
        Dict{String, Any}(),
        Ahorn.tileEntityFinalizer
    )
)

Ahorn.editingOptions(entity::StaticDebrisDashBlock) = Dict{String, Any}(
    "tiletype" => Ahorn.tiletypeEditingOptions(),
)

Ahorn.minimumSize(entity::StaticDebrisDashBlock) = 8, 8
Ahorn.resizable(entity::StaticDebrisDashBlock) = true, true

Ahorn.selection(entity::StaticDebrisDashBlock) = Ahorn.getEntityRectangle(entity)

Ahorn.renderAbs(ctx::Ahorn.Cairo.CairoContext, entity::StaticDebrisDashBlock, room::Maple.Room) = Ahorn.drawTileEntity(ctx, room, entity)

end
