local drawableNinePatch = require "structs.drawable_nine_patch"
local drawableSprite = require "structs.drawable_sprite"
local utils = require "utils"

local textures = {
    "block",
    "mirror",
    "temple",
    "stars"
}

local textureOptions = {}
for _, texture in ipairs(textures) do
    textureOptions[utils.titleCase(texture)] = texture
end

local customSwitchGate = {}

customSwitchGate.name = "ChronoHelper/CustomTimeSwitchGates"
customSwitchGate.depth = 0

customSwitchGate.minimumSize = {16, 16}
customSwitchGate.fieldInformation = {
    sprite = {
        options = textureOptions,
        editable = true
    }
}

customSwitchGate.nodeLimits = {1, 1}
customSwitchGate.nodeLineRenderType = "line"

customSwitchGate.placements = {}
for i, texture in ipairs(textures) do
    customSwitchGate.placements[i] = {
        name = string.format("Custom Timed Switch Gate (%s)", texture),
        data = {
            width = 16,
            height = 16,
            sprite = texture,
            persistent = false,
            moveTime =2.0,
            shakeTime = 0.5,
            preShakeTime = 0.1,
            postShakeTime = 0.1,
            moveEased = true,
        }
    }
end

local ninePatchOptions = {
    mode = "fill",
    borderMode = "repeat",
    fillMode = "repeat"
}

local frameTexture = "objects/switchgate/%s"
local middleTexture = "objects/switchgate/icon00"

function customSwitchGate.sprite(room, entity)
    local x, y = entity.x or 0, entity.y or 0
    local width, height = entity.width or 24, entity.height or 24

    local blockSprite = entity.sprite or "block"
    local frame = string.format(frameTexture, blockSprite)

    local ninePatch = drawableNinePatch.fromTexture(frame, ninePatchOptions, x, y, width, height)
    local middleSprite = drawableSprite.fromTexture(middleTexture, entity)
    local sprites = ninePatch:getDrawableSprite()

    middleSprite:addPosition(math.floor(width / 2), math.floor(height / 2))
    table.insert(sprites, middleSprite)

    return sprites
end

function customSwitchGate.selection(room, entity)
    local nodes = entity.nodes or {}
    local x, y = entity.x or 0, entity.y or 0
    local nodeX, nodeY = nodes[1].x or x, nodes[1].y or y
    local width, height = entity.width or 24, entity.height or 24

    return utils.rectangle(x, y, width, height), {utils.rectangle(nodeX, nodeY, width, height)}
end

return customSwitchGate
