local entityGravitySwitch = {}

local gravityOptions = {
    Up = 0,
    Down = 1,
    Left = 2,
    Right = 3,
    None = 4,
}

entityGravitySwitch.fieldInformation = {
    gravityType = {
        options = gravityOptions,
        editable = false
    }
}

entityGravitySwitch.name = "ChronoHelper/EntityGravitySwitch"
entityGravitySwitch.depth = -100
entityGravitySwitch.placements = {
    name = "Entity Gravity Switch",
    data = {
        gravityType = 4
    }
}

function entityGravitySwitch.texture(room, entity)
    if entity.gravityType == 0 then
        return "objects/chronohelper/entityGravitySwitch/switch_up00"
    elseif entity.gravityType == 1 then
        return "objects/chronohelper/entityGravitySwitch/switch_down00"
    elseif entity.gravityType == 2 then
        return "objects/chronohelper/entityGravitySwitch/switch_left00"
    elseif entity.gravityType == 3 then
        return "objects/chronohelper/entityGravitySwitch/switch_right00"
    else
        return "objects/chronohelper/entityGravitySwitch/switch_none00"
    end
end

return nil
