#define DECLARE_TEXTURE(Name, index) \
    texture Name: register(t##index); \
    sampler Name##Sampler: register(s##index)

#define SAMPLE_TEXTURE(Name, texCoord) tex2D(Name##Sampler, texCoord)

uniform float Time; // level.TimeActive
uniform float2 CamPos; // level.Camera.Position
uniform float2 Dimensions; // new Vector2(320, 180)

uniform float4x4 TransformMatrix;
uniform float4x4 ViewMatrix;

DECLARE_TEXTURE(text, 0);

float noise(float2 p){
    float n = dot(p, float2(127.1, 311.7));
    return frac(sin(n) * 43758.5453);
}

float smoothNoise(float2 p){
    float2 i = floor(p);
    float2 f = frac(p);
    float2 u = f * f * (3.0 - 2.0 * f);

    float n00 = noise(i);
    float n10 = noise(i + float2(1.0, 0.0));
    float n01 = noise(i + float2(0.0, 1.0));
    float n11 = noise(i + float2(1.0, 1.0));

    float x1 = lerp(n00, n10, u.x);
    float x2 = lerp(n01, n11, u.x);
    return lerp(x1, x2, u.y);
}

float fbm(float2 p){
    float total = 0.0;
    float amplitude = 0.5;
    float frequency = 1.0;

    [unroll]
    for (int i = 0; i < 6; i++)
    {
        total += amplitude * smoothNoise(p * frequency);
        frequency *= 2.0;
        amplitude *= 0.5;
    }

    return total;
}

float4 SpritePixelShader(float2 uv : TEXCOORD0) : COLOR0
{
    float2 worldPos = (uv * Dimensions) + (CamPos / 2);
    float3 color = SAMPLE_TEXTURE(text, uv);

    color *= 1.2;

    float brightness = (color.r,color.g,color.b) / 3;

    color *= brightness + 0.4;

    float fog = fbm(worldPos / 40) / 3;
    color += fog * abs(uv.y - 0.5);

    float3 sampled = color;
    float samplebrightness = brightness;
    float2 samplepos = uv;
    float dist = 1;
    float strength = 1;
    float dir = 0.0;
    for (int i = 0; i < 8; i++){
        sampled = SAMPLE_TEXTURE(text, float2(uv.x + (sin(dir) * 0.004),uv.y + (cos(dir) * 0.007)));
        samplebrightness = (sampled.r + sampled.g + sampled.b) / 3;

        if (samplebrightness + 0.01 < brightness){
            color += 0.0023;
        }
        if (samplebrightness - 0.01 > brightness){
            color -= 0.0023;
        }

        dir += 360 / 8;
    }
    for (int i = 0; i < 14; i++){
        samplepos = ((uv - 0.5) / dist) + 0.5;
        sampled = SAMPLE_TEXTURE(text, samplepos);
        if (sampled.r + sampled.g + sampled.b > 1.6){
            color += 0.007 * strength / clamp(brightness,0.5,1);
        }
        if (sampled.r + sampled.g + sampled.b > 2.5){
            color += 0.007 * strength;
        }
        strength /= 1.16;
        dist += 0.03;
    }
    dist = 1;
    dir = 0.0;

    for (int i = 0; i < 2; i++){
        for (int i = 0; i < 3; i++){
            samplepos = float2(uv.x + (sin(dir) * 0.007 * dist),uv.y + (cos(dir) * 0.008 * dist));
            sampled = SAMPLE_TEXTURE(text, samplepos);
            samplebrightness = (sampled.r,sampled.g,sampled.b) / 3;
            color += samplebrightness / 0.5 / (dist * 20);
            
            dir += 72;
        }
        dist += 1;
    }
    color *= 1.1;
    color.rg /= 1.2;
    color += float3(fog / 1.5,fog / 1.3,fog) * (1 - uv.y) / 1.8;

    color *= 1.5 - uv.y;

    return float4(color,1.0);
}

void SpriteVertexShader(inout float4 color    : COLOR0,
                        inout float2 texCoord : TEXCOORD0,
                        inout float4 position : SV_Position)
{
    position = mul(position, ViewMatrix);
    position = mul(position, TransformMatrix);
}

technique Shader
{
    pass pass0
    {
        VertexShader = compile vs_3_0 SpriteVertexShader();
        PixelShader = compile ps_3_0 SpritePixelShader();
    }
}