#define DECLARE_TEXTURE(Name, index) \
    texture Name: register(t##index); \
    sampler Name##Sampler: register(s##index)

#define SAMPLE_TEXTURE(Name, texCoord) tex2D(Name##Sampler, texCoord)

uniform float Time; // level.TimeActive
uniform float2 CamPos; // level.Camera.Position
uniform float2 Dimensions; // new Vector2(320, 180)

uniform float4x4 TransformMatrix;
uniform float4x4 ViewMatrix;

DECLARE_TEXTURE(text, 0);

float noise(float2 p){
    float n = dot(p, float2(127.1, 311.7));
    return frac(sin(n) * 43758.5453);
}

float smoothNoise(float2 p){
    float2 i = floor(p);
    float2 f = frac(p);
    float2 u = f * f * (3.0 - 2.0 * f);

    float n00 = noise(i);
    float n10 = noise(i + float2(1.0, 0.0));
    float n01 = noise(i + float2(0.0, 1.0));
    float n11 = noise(i + float2(1.0, 1.0));

    float x1 = lerp(n00, n10, u.x);
    float x2 = lerp(n01, n11, u.x);
    return lerp(x1, x2, u.y);
}

float fbm(float2 p){
    float total = 0.0;
    float amplitude = 0.5;
    float frequency = 1.0;

    [unroll]
    for (int i = 0; i < 2; i++)
    {
        total += amplitude * smoothNoise(p * frequency);
        frequency *= 2.0;
        amplitude *= 0.5;
    }

    return total;
}

float4 SpritePixelShader(float2 uv : TEXCOORD0) : COLOR0
{
    float2 worldPos = (uv * Dimensions) + CamPos;
    float3 color = SAMPLE_TEXTURE(text, uv).rgb;

    if (color.r == 1 && color.g == 0 && color.b == 1){
        color = fbm(uv * 10);
        color = floor(color * 10) / 10;
        color.gb /= 1.5;

        float dir = 0;
        float3 sampled = color;
        float2 samplepos = uv;
        float offset = fbm(worldPos / 8);
        for (int i = 0; i < 4; i++){
            samplepos = float2(uv.x + (sin(dir) / Dimensions.x * (1 + offset * 10)),uv.y + (cos(dir) / Dimensions.y * (1 + offset * 10)));
            sampled = SAMPLE_TEXTURE(text, samplepos).rgb;
            if (sampled.r != 1 || sampled.g != 0 || sampled.b != 1){
                color = float3(1.0,0.0,0.0);
                i = 4;
            }
            dir += 90;
        }
        for (int i = 0; i < 4; i++){
            samplepos = float2(uv.x + (sin(dir) / Dimensions.x),uv.y + (cos(dir) / Dimensions.y));
            sampled = SAMPLE_TEXTURE(text, samplepos).rgb;
            if (sampled.r != 1 || sampled.g != 0 || sampled.b != 1){
                color = float3(0.0,0.0,0.0);
                i = 4;
            }
            dir += 90;
        }
    }

    return float4(color,1.0);
}

void SpriteVertexShader(inout float4 color    : COLOR0,
                        inout float2 texCoord : TEXCOORD0,
                        inout float4 position : SV_Position)
{
    position = mul(position, ViewMatrix);
    position = mul(position, TransformMatrix);
}

technique Shader
{
    pass pass0
    {
        VertexShader = compile vs_3_0 SpriteVertexShader();
        PixelShader = compile ps_3_0 SpritePixelShader();
    }
}