local monocle = require("#monocle")

local vector2 = require("#microsoft.xna.framework.vector2")

function onBegin(room)
  disableMovement()
  disableRetry()
  player.ForceCameraUpdate = true
  wait(2)
  playSound("event:/game/06_reflection/fall_spike_smash", player.Position)
  engine.Scene:NextColorGrade("none")
  wait(3.5)
  engine.Scene:NextColorGrade("Donker19/LackOfInsiration/0_BlackFade")
  wait(2)
  setFlag("donk_CrackHelmet_Out", true)
  setFlag("donk_CrackHelmet", true)
  wait(0.1)
  coroutine.yield(getLevel():ZoomTo(vector2(160, 90), 1.6, 2))
  say("Ch3_FallenDown_IcePlanet_1")
  engine.Scene:NextColorGrade("none")
  wait(1)
  wait(0.2)
  say("Ch3_FallenDown_IcePlanet_2")
  setFlag("donk_OxygenAlertEnable", true)
  coroutine.yield(engine.Scene:ZoomBack(1))
  enableMovement()
end

function onEnd(room, wasSkipped)
  enableMovement()
  setFlag("donk_CrackHelmet_Out", true)
  setFlag("donk_CrackHelmet", true)
  setFlag("donk_OxygenAlertEnable", true)
  engine.Scene:NextColorGrade("none")
  player.DummyAutoAnimate = true
  player.ForceCameraUpdate = true
  getLevel():ResetZoom()
  enableMovement()
end