local drawableSprite = require("structs.drawable_sprite")
local drawing = require("utils.drawing")
local utils = require("utils")
local PersistenceHelperGlamBall = {}

PersistenceHelperGlamBall.name = "PersistenceHelper/GlamBall"
PersistenceHelperGlamBall.depth = 0
PersistenceHelperGlamBall.nodeLineRenderType = "line"
PersistenceHelperGlamBall.nodeLimits = {0, -1}
PersistenceHelperGlamBall.fieldInformation = {
    amount = {
        fieldType = "integer",
    }
}
PersistenceHelperGlamBall.placements = {
    {
        name = "netuneball",
        data = {
            amount = 3,
            offset = 0.0,
            speed = 1.0,
            notCoreMode = false
        }
    },
    {
        name = "glamball",
        data = {
            amount = 3,
            offset = 0.0,
            speed = 1.0,
            notCoreMode = true
        }
    }
}



function PersistenceHelperGlamBall.sprite(room, entity)
    local sprites = {}
    local tex = entity.notCoreMode and "objects/sunsetquasar/PersistenceHelper/fireball/fireball09" or "objects/sunsetquasar/PersistenceHelper/fireball/fireball01"
    table.insert(sprites, drawableSprite.fromTexture(tex, entity))
    return sprites
end

function PersistenceHelperGlamBall.selection(room, entity)
    local x, y = entity.x, entity.y
    local rects = {}

    for _, node in ipairs(entity.nodes) do
        table.insert(rects, utils.rectangle(node.x-8, node.y-8, 16, 16))
    end

    local mainRectangle = utils.rectangle(x-8, y-8, 16, 16)
    return mainRectangle, rects
end





return PersistenceHelperGlamBall