local drawableNinePatch = require("structs.drawable_nine_patch")
local drawableSprite = require("structs.drawable_sprite")

local PersistenceHelperGlamNetuneBlock = {}

PersistenceHelperGlamNetuneBlock.name = "PersistenceHelper/GlamNetuneBlock"
PersistenceHelperGlamNetuneBlock.depth = 8990
PersistenceHelperGlamNetuneBlock.minimumSize = {16, 16}
PersistenceHelperGlamNetuneBlock.placements = {
    {
        name = "netune",
        data = {
            width = 16,
            height = 16,
            notCoreMode = false
        }
    },
    {
        name = "glam",
        data = {
            width = 16,
            height = 16,
            notCoreMode = true
        }
    },
}

local ninePatchOptions = {
    mode = "fill",
    borderMode = "repeat",
    fillMode = "repeat"
}

local fireBlockTexture = "objects/sunsetquasar/PersistenceHelper/BumpBlockNew/Fire06"
local fireBlockTexture2 = "objects/sunsetquasar/PersistenceHelper/BumpBlockNew/fire_bg"
local fireCrystalTexture = "objects/sunsetquasar/PersistenceHelper/BumpBlockNew/center09"

local iceBlockTexture = "objects/sunsetquasar/PersistenceHelper/BumpBlockNew/Ice02"
local iceBlockTexture2 = "objects/sunsetquasar/PersistenceHelper/BumpBlockNew/ice_bg"
local iceCrystalTexture = "objects/sunsetquasar/PersistenceHelper/BumpBlockNew/center13"

local function getBlockTexture(entity)
    if entity.notCoreMode then
        return iceBlockTexture, iceBlockTexture2, iceCrystalTexture

    else
        return fireBlockTexture, fireBlockTexture2, fireCrystalTexture
    end
end

function TableConcat(t1,t2)
    for i=1,#t2 do
        t1[#t1+1] = t2[i]
    end
    return t1
end


function PersistenceHelperGlamNetuneBlock.sprite(room, entity)
    local x, y = entity.x or 0, entity.y or 0
    local width, height = entity.width or 24, entity.height or 24

    local blockTexture, blockTexture2, crystalTexture = getBlockTexture(entity)

    local ninePatch = drawableNinePatch.fromTexture(blockTexture2, ninePatchOptions, x, y, width, height)
    local ninePatch2 = drawableNinePatch.fromTexture(blockTexture, ninePatchOptions, x, y, width, height)
    local crystalSprite = drawableSprite.fromTexture(crystalTexture, entity)
    local sprites = ninePatch:getDrawableSprite()
    local sprites2 = ninePatch2:getDrawableSprite()

    crystalSprite:addPosition(math.floor(width / 2), math.floor(height / 2))
    
    sprites = TableConcat(sprites, sprites2)
    table.insert(sprites, crystalSprite)

    return sprites
end

return PersistenceHelperGlamNetuneBlock