local badeline = nil

local function badeline_appears(left_side)
  local pos_x, scale
  if left_side then
    pos_x = 102880
    scale = 1
  else
    pos_x = 102880
    scale = -1
  end
  local pos_y = 3010

  badeline = celeste.BadelineDummy(vector2(pos_x, pos_y))
  badeline.Sprite.Scale = vector2(scale, 1.0)
  getLevel():Add(badeline)

  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  playSound("event:/char/badeline/appear", badeline.Position)
  setFlag("BadelineSpawned", true)

  wait()
end

local function badeline_vanishes()
  badeline:Vanish()
  celeste.Input.Rumble(getEnum("Celeste.RumbleStrength", "Medium"), getEnum("Celeste.RumbleLength", "Medium"))
  badeline = nil

  wait()
end

function onBegin()

  local abyss = getFlag("AbyssClear")

  makeUnskippable()
  disableMovement()
  wait(0.125)
  if getFlag("MetBadeline") then
    wait(0.375)
    badeline_appears()
    if not getFlag("StillHangout") then
      say("CC_Flamecrafter113_TemporalRift_BadelineHangout_IntroRevisit")
      setMusicProgression(2)
    end
  else
    wait(0.5)
    walk(-12)
    wait(0.5)
    walk(20)
    wait(0.125)
    player.DummyAutoAnimate = false
    player.Sprite:Play("Hangout_Start")
    coroutine.yield(celeste.CutsceneEntity.CameraTo(vector2(102550, 2914), 2.5))
    if abyss then
      say("CC_Flamecrafter113_TemporalRift_BadelineHangout_IntroLandingAbyss")
    else
      say("CC_Flamecrafter113_TemporalRift_BadelineHangout_IntroLandingNoAbyss")
    end
    wait(0.325)
    setMusicProgression(1)
    wait(0.25)
    coroutine.yield(celeste.CutsceneEntity.CameraTo(vector2(102625, 2914), 2.75))
    wait(0.15)
    badeline_appears()
    wait(0.15)
    playSound("event:/FlamecrafterCollabs/FlamecrafterCrossover_AHiT/Sounds/HangoutStartled")
    player.Sprite:Play("Hangout_Surprised")
    wait(0.05)
    local level = getLevel()
    coroutine.yield(level:ZoomTo(vector2(215, 90), 2, 0.25))
    wait()
    wait(0.25)
    setFlag("MetBadeline")
    if abyss then
      wait(1.325)
      player.Sprite:Play("Hangout_Lower")
      setMusicProgression(2)
      say("CC_Flamecrafter113_TemporalRift_BadelineHangout_IntroAbyss")
    else
      say("CC_Flamecrafter113_TemporalRift_BadelineHangout_IntroNoAbyss")
      wait(0.625)
      player.Sprite:Play("Hangout_Lower")
      wait(1)
      setMusicProgression(2)
      say("CC_Flamecrafter113_TemporalRift_BadelineHangout_IntroNoAbyssPt2")
    end
    player.Sprite:Play("Hangout_End", true)
    wait(1.125)
    coroutine.yield(celeste.CutsceneEntity.CameraTo(vector2(102644, 2914), 0.5))
    player.DummyAutoAnimate = true
    walkTo(102840)
    wait()
    player.DummyAutoAnimate = false
    player.Sprite:Play("Hangout_Endidle", true)
    wait(0.125)
    if abyss then
      say("CC_Flamecrafter113_TemporalRift_BadelineHangout_IntroMainAbyss")
    else
      say("CC_Flamecrafter113_TemporalRift_BadelineHangout_IntroMainNoAbyss")
    end
    local level = getLevel()
    coroutine.yield(level:ZoomBack(0.75))
  end
  setFlag("MetBadeline", true)
  enableMovement()
end

function onEnd()
  enableMovement()
  setFlag("StillHangout", true)
  setFlag("MetBadeline", true)
end
