-- NOTES:

-- OnInteraction > Animation
-- > Flag that activates styleground with debris falling + Hornet escaping
-- > WakeUp anim


--  after upgrade animation > Flag triggered falling blocks, until one blocks way
-- rock screen wipe
-- play same Hornet anim as in Hornet Cutscenes
-- WakeUp anim
-- CC_XELKHK_CUTS_KE_A
-- WakeUp anim

local lua_helper = celeste.Mod.LuaCutscenes.LuaHelper

local function makeCoroutine(func)
	return monocle.Coroutine(lua_helper.LuaCoroutineToIEnumerator(coroutine.create(func)))
end

local function exitIfUpgradeCollected() -- checks if the upgrade has finished its collection on every frame
	while not getFlag("KingsBrand") do
		wait()
		disableMovement()
		disableRetry()
	end
	-- when KingsBrand is true, do the thing
	disableMovement()
	disableRetry()
	wait(0.05)
	setFlag("CastOffShellIsBreaking",true)
	--getLevel().InCutscene = true -- cutscene can be skipped from now on
	setMusicLayer (1, 0)
	setMusicLayer (2, 0)
	setMusicLayer (3, 0)
	coroutine.yield(celeste.CutsceneEntity.CameraTo(vector2(7260,1550), 3.5)) -- moves the camera towards the falling blocks
	wait(1.4)
	setFlag("CastOffShellIsBreaking7",true)
	wait(0.25)
	setFlag("CastOffShellIsBreaking6",true)
	player.Facing = getEnum("Celeste.Facings", "Left")
	coroutine.yield(celeste.CutsceneEntity.CameraTo(vector2(7500,1550), 0.9))
	playSound("event:/CC/CC_HollowKnight/SFX/Scene/HornetCastoffYell")
	setFlag("CastOffShellHornetEscapes",true)
	wait(0.15)
	playSound("event:/CC/CC_HollowKnight/SFX/Scene/HornetCastoffNeedle")
	wait(0.05)
	setFlag("CastOffShellIsBreaking8",true)
	setFlag("CastOffShellScreenWipe",true)
	wait(0.55)
	setFlag("blackFade",true)
	teleportTo(7256,1664)
	setFlag("CastOffShellIsBreaking",false)
	wait(0.4)
	player.ForceCameraUpdate = true
	wait(0.5)
	setFlag("blackFade",false)
	player.DummyAutoAnimate = false
	player.Sprite:Play("wakeUp")
	wait(1.5)
	player.DummyAutoAnimate = true
	say("CC_XELKHK_CUTS_KE_A")
	player.ForceCameraUpdate = false
	enableMovement()
	endCutscene()
end

function onBegin()
	disableMovement()
	disableRetry()
	--getLevel().InCutscene = false -- unskippable for now
	walkTo(7776)
	setFlag("CastOffShellCollectableAppears",true)
	disableMovement()
	player:Add(makeCoroutine(exitIfUpgradeCollected))
end

function onEnd(room, wasSkipped)
	if wasSkipped then
		enableMovement()
		setFlag("blackFade",false)
		setFlag("CastOffShellIsBreaking",true)
		for i=2,8 do
			setFlag("CastOffShellIsBreaking"..i,true)
		end
		setFlag("CastOffShellScreenWipe",false)
		setMusicLayer (1, 1)
		setMusicLayer (3, 1)
		enableRetry()
		teleportTo(7256,1664)
	end
	enableMovement()
	enableRetry()
	setMusicLayer (1, 1)
	setMusicLayer (3, 1)
end