-- NOTES:

-- Nail pickup animation > flash > dialog

function onBegin()
	if not getFlag("HK_IntroHasBeenPlayed") then
		disableMovement()
		disableRetry()
		setFlag("HK_CantOpenMap",true)
		getLevel().InCutscene = false -- We make sure the cutscene can't be skipped while falling
		setPlayerState(18) -- Ensures player is falling
		player.ForceCameraUpdate = true
		wait(0.5)
		coroutine.yield(getLevel():ZoomTo(vector2(168, 40), 1.3, 0.98)) -- This is the zoom, the vector2 indicates the coordinates (middle of the screen), the amount, and duration
		-- Coroutine means that the zoom is happening at the same time the next instruction (walking) is happening
		setPlayerState(11) -- Player goes back to dummySt
		getLevel().InCutscene = true -- The cutscene can be skipped from now on
		player.DummyAutoAnimate = false -- Allows us to play animations
		player.Sprite:Play("fallPose")
		player.ForceCameraUpdate = false
		coroutine.yield(celeste.CutsceneEntity.CameraTo(vector2(501,172), 1.1)) -- Moves the camera to these coordinates and takes 1.1 seconds to move
		wait(0.1)
		player.Sprite:Play("lookUp")
		wait(0.75)
		player.DummyAutoAnimate = true
		wait(0.25)
		say("CC_XELKHK_CUTS_HC_A")
		walk(32)
		wait(0.7)
		player.Facing = getEnum("Celeste.Facings", "Left")
		wait(0.4)
		walk(-64)
		wait(0.5)
		player.Facing = getEnum("Celeste.Facings", "Right")
		wait(0.7)
		run(96)
		jump(0.5)
		run(24)
		wait(0.5)
		say("CC_XELKHK_CUTS_HC_B")
		wait(0.2)
		playSound("event:/CC/CC_HollowKnight/SFX/Boss SFX/Sword2")
		playSound("event:/CC/CC_HollowKnight/SFX/Boss SFX/Sword2")
		playSound("event:/CC/CC_HollowKnight/SFX/Boss SFX/Sword2")
		playSound("event:/CC/CC_HollowKnight/SFX/Boss SFX/Sword2") -- This is so silent so we're playing it multiple times
		wait(0.075)
		playSound("event:/game/07_summit/gem_get")
		getLevel().Displacement:AddBurst(player.Position + vector2(0,-8), 0.5, 16, 36, 0.75) -- (position, duration, radiusFrom, radiusTo, alpha)
		wait(1.6)
		say("CC_XELKHK_CUTS_HC_C")
		playSound("event:/CC/CC_HollowKnight/SFX/Scene/IntroSting")
		player.ForceCameraUpdate = true
		coroutine.yield(getLevel():ZoomAcross(vector2(640,172), 1, 0.75))
	end
end

function onEnd(room, wasSkipped)
	if wasSkipped then
		getLevel():ResetZoom()
		playSound("event:/CC/CC_HollowKnight/SFX/Scene/IntroSting")
		player.Facing = getEnum("Celeste.Facings", "Right")
		teleportTo(708,264)
	end
	setFlag("HK_IntroHasBeenPlayed",true)
	enableMovement()
	enableRetry()
end