-- NOTES:

-- on interaction, collect upgrade anim/flag
-- > ground breaks > fall down (disableMovement)

local lua_helper = celeste.Mod.LuaCutscenes.LuaHelper

local function makeCoroutine(func)
	return monocle.Coroutine(lua_helper.LuaCoroutineToIEnumerator(coroutine.create(func)))
end

local function fallIfUpgradeCollected() -- checks if the upgrade has finished its collection on every frame
	while not getFlag("DesolateDash") do
		wait()
		disableMovement()
	end
	-- when DesolateDash is true, do the thing
	disableMovement()
	player.ForceCameraUpdate = true
	getLevel().InCutscene = true -- can be skipped now
	--miniTextbox("CC_XELKHK_CUTS_CoT_A")
	disableMovement()
	playSound("event:/CC/CC_HollowKnight/SFX/Scene/SoulMasterStun")
	setFlag("SoulmasterScream",true)
	wait(0.4)
	setFlag("SoulmasterCutscene_ParticlesB",true)
	setFlag("SoulmasterScream",false)
	setFlag("SoulmasterDiveBegin",true)
	wait(0.3)
	playSound("event:/CC/CC_HollowKnight/SFX/Scene/SoulMasterCast")
	wait(0.4)
	setFlag("SoulmasterDive",true)
	setFlag("SoulmasterDiveBegin",false)
	wait(0.2)
	playSound("event:/CC/CC_HollowKnight/SFX/Scene/StrikeImpact",player.Position)
	setFlag("SoulmasterCutscene_ParticlesC",true)
	setFlag("SoulSanctumBreakOne",true)
	setFlag("SoulmasterDive",false)
	wait(0.75)
	playSound("event:/CC/CC_HollowKnight/SFX/Scene/GlassFloorBreak",player.Position)
	wait(1.7)
	player.ForceCameraUpdate = false
	onEnd()
	endCutscene()
end

function onBegin()
	disableMovement()
	getLevel().InCutscene = false -- unskippable for now
	walkTo(3048)
	setFlag("DesolateDashCollectableAppears",true)
	disableMovement()
	player:Add(makeCoroutine(fallIfUpgradeCollected))
end

function onEnd(room, wasSkipped)
	if wasSkipped then
		enableMovement()
		teleportTo(3048,2776,"CoT-01")
	end
	enableMovement()
	getLevel().InCutscene = false
end