local save = require("#Celeste.Mod.CrossoverCollab.Code.PointsStuff.PointsModule")
local bettertext = require("#Celeste.Mod.CrossoverCollab.Code.PointsStuff.BetterTextbox")

-- Adds a flag with the name inside the function
function addflag(flag)
    save.SaveData:AddFlag(flag)
end

-- Removes a flag
function removeflag(flag)
    save.SaveData:RemoveFlag(flag)
end

-- Returns if a flag exists, if it does, returns true, if it doesn't returns false
function isflagtrue(flag)
    return save.SaveData:IsFlagTrue(flag)
end

--adds the value [money] to their total
function addmoney(money)
    save.SaveData:AddMoney(tonumber(money))
end
--returns a bool, checks if they have more remaining money than the value [money]
function checkmoney(money)
    return save.SaveData:CheckMoney(tonumber(money))
end
--returns the amount of money the have left
function getmoney()
    return save.SaveData:GetMoney()
end

function bettersay(dialog)
    coroutine.yield(bettertext.Say(tostring(dialog)))
end

function onTalk()
	disableMovement()
	disableRetry()
	
	if isflagtrue("quest_arcadecoupon") then
		say("CC_Lobby_ArcadeManager_Quest")
		removeflag("quest_arcadecoupon")
		addflag("quest_comic")
		setFlag("quest_arcadecoupon",false)
		setFlag("quest_comic",true)
		playSound("event:/game/general/assist_nonsolid_out")
		endCutscene()
	end
	
	if not isflagtrue("ArcadeManagerFirstTime") then
		say("CC_Lobby_ArcadeManager_First")
		addflag("ArcadeManagerFirstTime")
	else
		if isflagtrue("JustADream_heart") or isflagtrue("puffleLaunchRace_heart") or isflagtrue("curly_heart")
		or isflagtrue("CCKids_heart") or isflagtrue("Adam Korinek_heart") or isflagtrue("FIERecyclingPlant_heart") then
			-- todo wip shop
			-- apps to sell: berryChat, berryPaint, calculator, defrag
			if isflagtrue("calculator_bought") and isflagtrue("defrag_bought") and isflagtrue("berryChat_bought") and isflagtrue("berryPaint_bought") then
				say("CC_Lobby_ArcadeManager_ShopAllBought")
				
				-- shop mode entered here
			else
				say("CC_Lobby_ArcadeManager_Shop")
				shopBuying()
			end
		else
			say("CC_Lobby_ArcadeManager_Normal")
		end
	end
end

function shopBuying()
	-- Shop menu opens here.
	-- Items that were already bought will not be available for purchase
	local boughtItem=false
	choiceDialog({
	{
	"CC_Lobby_ArcadeManager_Buy_calculator",
	requires = function()
		return isflagtrue("calculator_bought") == false
	end,
	onChosen = function()
		local ifBought = shopConfirmation(10,"calculator")
		if ifBought then
			addflag("calculator_bought")
		else
			shopBuying()
		end
	end,
	repeatable = true
	},
	{
	"CC_Lobby_ArcadeManager_Buy_defrag",
	requires = function()
		return isflagtrue("defrag_bought") == false
	end,
	onChosen = function()
		local ifBought = shopConfirmation(15,"defrag")
		if ifBought then
			addflag("defrag_bought")
		else
			shopBuying()
		end
	end,
	repeatable = true
	},
	{
	"CC_Lobby_ArcadeManager_Buy_berryChat",
	requires = function()
		return isflagtrue("berryChat_bought") == false
	end,
	onChosen = function()
		local ifBought = shopConfirmation(20,"berryChat")
		if ifBought then
			addflag("berryChat_bought")
		else
			shopBuying()
		end
	end,
	repeatable = true
	},
	{
	"CC_Lobby_ArcadeManager_Buy_berryPaint",
	requires = function()
		return isflagtrue("berryPaint_bought") == false
	end,
	onChosen = function()
		local ifBought = shopConfirmation(25,"berryPaint")
		if ifBought then
			addflag("berryPaint_bought")
		else
			shopBuying()
		end
	end,
	repeatable = true
	},
	{
	"CC_Lobby_Shop_Buy_Bye",
	onChosen = function()
		say("CC_Lobby_ArcadeManager_AnythingElse")
		closeChoiceDialog()
		wait(0.1)
	end
	}
	})
end

function shopConfirmation(price,cdName) -- This function is given a price and returns true if the player buys the item
	bettersay("[STAR left normal]{#E2BEA8}We've got this listed at...{#} {#F94A4A}"..tostring(price).."G{#} {#E2BEA8}and you have{#} {#F94A4A}"..tostring(getmoney()).."G{#}{#E2BEA8}... You sure you want it? No refunds!{#}")
	if choice("CC_Lobby_Shop_Buy_YesPlease", "CC_Lobby_Shop_Buy_NoThankYou") == 1 then
		if checkmoney(price) then -- Does the player have enough money?
			if cdName == "calculator" then
				say("CC_Lobby_ArcadeManager_Bought_Calculator")
			elseif cdName == "defrag" then
				say("CC_Lobby_ArcadeManager_Bought_defrag")
			elseif cdName == "berryChat" then
				say("CC_Lobby_ArcadeManager_Bought_berryChat")
			elseif cdName == "berryPaint" then
				say("CC_Lobby_ArcadeManager_Bought_berryPaint")
			else
				say("CC_Lobby_ArcadeManager_Bought_undefined")
			end
			addmoney(price*-1)
			playSound("event:/CC/CC_Lobby/CC_money")
			return true
		else
			bettersay("[STAR left normal]{#E2BEA8}I said that it's{#} {#F94A4A}"..tostring(price).."G...{#}{n}{#E2BEA8}You should get a job first and then come back!{n}I heard Comox can give big payments to playtesters that earn a lot of{#} {#F94A4A}Points{#}{#E2BEA8}!{#}")
		end
	else
		say("CC_Lobby_ArcadeManager_AnythingElse")
		return false
	end
end

function onEnd(room, wasSkipped)
	enableMovement()
	enableRetry()
end