local save = require("#Celeste.Mod.CrossoverCollab.Code.PointsStuff.PointsModule")

-- Adds a flag with the name inside the function
function addflag(flag)
    save.SaveData:AddFlag(flag)
end

-- Removes a flag
function removeflag(flag)
    save.SaveData:RemoveFlag(flag)
end

-- Returns if a flag exists, if it does, returns true, if it doesn't returns false
function isflagtrue(flag)
    return save.SaveData:IsFlagTrue(flag)
end

math.randomseed(os.time())

function onTalk()
	disableMovement()
	if isflagtrue("quest_comic") then
		say("CC_Lobby_EchoPyre_Quest")
		removeflag("quest_comic")
		addflag("quest_computer")
		setFlag("quest_computer",true)
		setFlag("quest_comic",false)
		playSound("event:/game/general/assist_nonsolid_out")
		onEnd()
		endCutscene()
	elseif getFlag("weatherRain") then
		echoPyre = math.random(1,2)
		for i=1,2,1 do
			if echoPyre == i then
				say("CC_Lobby_EchoPyre_Rain"..tostring(i))
			end
			i = i + 1
		end
	else
		echoPyre = math.random(1,3)
		for i=1,3,1 do
			if echoPyre == i then
				say("CC_Lobby_EchoPyre_Normal"..tostring(i))
			end
			i = i + 1
		end
	end
end

function onEnd()
	enableMovement()
end