local save = require("#Celeste.Mod.CrossoverCollab.Code.PointsStuff.PointsModule")
local bettertext = require("#Celeste.Mod.CrossoverCollab.Code.PointsStuff.BetterTextbox")

function addflag(flag)
    save.SaveData:AddFlag(flag)
end

function removeflag(flag)
    save.SaveData:RemoveFlag(flag)
end

function isflagtrue(flag)
    return save.SaveData:IsFlagTrue(flag)
end

--adds the value [money] to their total
function addmoney(money)
    save.SaveData:AddMoney(tonumber(money))
end

--returns the amount of money you have left
function getmoney()
    return save.SaveData:GetMoney()
end

function bettersay(dialog)
    coroutine.yield(bettertext.Say(tostring(dialog)))
end

math.randomseed(os.time())

wordList = { "reflection", "coding", "walking", "veggies", "snails", "drought" }

function getRandomWord()
    local index = math.random(#wordList)
    return wordList[index]
end

function onTalk()
    local timestr = os.date("*t").hour .. ":" .. os.date("*t").min
    if os.date("*t").min < 10 then
        timestr = os.date("*t").hour .. ":0" .. os.date("*t").min
    end

    disableMovement()

    if isflagtrue("quest_computer") then
        say("CC_Lobby_City_ellatas_Quest")
        removeflag("quest_computer")
        addflag("quest_finished")
        setFlag("quest_computer", false)
        addmoney(45)
        playSound("event:/CC/CC_Lobby/CC_money")
        bettersay("You got {#F94A4A}{~}45G{#}{/~}! You have now " .. tostring(getmoney()) .. "G")
        onEnd()
        endCutscene()
    end

    local randomWord = getRandomWord(word)

    if getFlag("weatherRain") then
        ellaTAS = math.random(1, 6)
        for i = 1, 4, 1 do
            if ellaTAS == i then
                say("CC_Lobby_City_ellatas_Rain" .. tostring(i))
            end
            i = i + 1
        end
        if ellaTAS == 5 then
            bettersay("Rain is good for " .. getRandomWord() .. ". What do you think?")
        elseif ellaTAS == 6 then
            if os.date("*t").hour >= 6 and os.date("*t").hour <= 11 then
                bettersay(tostring("It's " .. timestr ..
                    " already! {n} I slept great last night, the sound of the rain calms me. Do you feel the same?"))
            elseif os.date("*t").hour >= 11 and os.date("*t").hour <= 23 then
                bettersay(tostring("Wow, it's already " ..
                    timestr .. "...{n} I think I'll go home soon and play Terraria with my girlfriend."))
            else
                bettersay(tostring("Funny how the light pollution makes it look like it's always daytime even if it's " ..
                    os.date("*t").hour .. ", huh?"))
            end
        end
    else
        if isflagtrue("quest_finished") then
            ellaTAS = math.random(1, 5)
            for i = 1, 5, 1 do
                if ellaTAS == i then
                    say("CC_Lobby_City_ellatas_Normal" .. tostring(i))
                end
                i = i + 1
            end
        else
            ellaTAS = math.random(1, 7)
            for i = 1, 6, 1 do
                if ellaTAS == i then
                    say("CC_Lobby_City_ellatas_Normal" .. tostring(i))
                end
                i = i + 1
            end
            if ellaTAS == 7 then
                if os.date("*t").hour >= 6 and os.date("*t").hour <= 11 then
                    bettersay(tostring("It's still " ..
                        timestr .. "... *Yawns* {n} I went to bed too late yesterday and I'm eepy."))
                elseif os.date("*t").hour >= 11 and os.date("*t").hour <= 23 then
                    bettersay(tostring("It's " ..
                        timestr .. "...{n} The weather today is perfect to get some sunlight, isn't it?"))
                else
                    bettersay(tostring("You should be going to sleep.{n}" ..
                        timestr .. " is not the best hour to be awake."))
                    bettersay(tostring("Me? I just needed some fresh air.{n}I got a lot of things on my mind recently."))
                end
            end
        end
    end
end

function onEnd()
    enableMovement()
end
