local luaCutscenesUtils = require("#Celeste.Mod.MaxHelpingHand.Module.LuaCutscenesUtils")
local save = require("#Celeste.Mod.CrossoverCollab.Code.PointsStuff.PointsModule")
local bettertext = require("#Celeste.Mod.CrossoverCollab.Code.PointsStuff.BetterTextbox")

function getmoney()
    return save.SaveData:GetMoney()
end

function getpoints()
    return save.SaveData:GetPoints();
end

function bettersay(dialog)
    coroutine.yield(bettertext.Say(tostring(dialog)))
end

-- Adds a flag with the name inside the function
function addflag(flag)
    save.SaveData:AddFlag(flag)
end

-- Returns if a flag exists, if it does, returns true, if it doesn't returns false
function isflagtrue(flag)
    return save.SaveData:IsFlagTrue(flag)
end

-- Removes a flag
function removeflag(flag)
    save.SaveData:RemoveFlag(flag)
end

function onTalk()
	disableMovement ()
	wait(0.1)
	math.randomseed(os.time())
	vendingMachineChance = math.random(0,100)
	if vendingMachineChance < 1 then
		playSound("event:/game/04_cliffside/whiteblock_fallthru")
		wait(0.20)
		playSound("event:/game/04_cliffside/whiteblock_fallthru")
		wait(0.15)
		if not isflagtrue("quest_orangejuice") and not isflagtrue("quest_orangejuicedone") and not isflagtrue("quest_finished") and not isflagtrue("quest_apple")
		and not isflagtrue("quest_comic") and not isflagtrue("quest_arcadecoupon") and not isflagtrue("quest_computer") then
			bettersay("WOW!! An {#F94A4A}orange juice{#} and a snack just fell off without inserting any coins!{n}You feel {~}extremely{/~} lucky today.")
			engine.Scene.Session:SetCounter("snacksInHand", engine.Scene.Session:GetCounter("snacksInHand") + 1)
			addflag("quest_orangejuice")
			addflag("quest_orangejuicedone")
			setFlag("quest_orangejuice",true)
		else
			bettersay("WOW!! Two snacks just fell off without inserting any coins!{n}You feel {~}extremely{/~} lucky today.")
			engine.Scene.Session:SetCounter("snacksInHand", engine.Scene.Session:GetCounter("snacksInHand") + 2)
		end
	elseif vendingMachineChance > 92 then
		playSound("event:/game/04_cliffside/whiteblock_fallthru")
		wait(0.15)
		if not isflagtrue("quest_orangejuice") and not isflagtrue("quest_orangejuicedone") and not isflagtrue("quest_finished") and not isflagtrue("quest_apple")
		and not isflagtrue("quest_comic") and not isflagtrue("quest_arcadecoupon") and not isflagtrue("quest_computer") then
			bettersay("Omg! An {#F94A4A}orange juice{#} just fell off without inserting any coins!{n}You feel lucky today.")
			addflag("quest_orangejuice")
			addflag("quest_orangejuicedone")
			setFlag("quest_orangejuice",true)
		else
			bettersay("Omg! A snack just fell off without inserting any coins!{n}You feel lucky today.")
			engine.Scene.Session:SetCounter("snacksInHand", engine.Scene.Session:GetCounter("snacksInHand") + 1)
		end
	else
		if not getFlag("vendingMachineKeptInsisting") then
			bettersay("This vending machine is full of drinks and snacks,{n}but it's quite expensive.{n}You hope that one will suddenly fall for free.")
			engine.Scene.Session:SetCounter("timesInteractedUnsuccessfullyWithVendingMachine", engine.Scene.Session:GetCounter("timesInteractedUnsuccessfullyWithVendingMachine") + 1)
			setFlag("vendingMachineKeptInsisting",true)
		else
			if isflagtrue("quest_orangejuice") or isflagtrue("quest_orangejuicedone") or isflagtrue("quest_finished") or isflagtrue("quest_apple")
			or isflagtrue("quest_comic") or isflagtrue("quest_arcadecoupon") or isflagtrue("quest_computer") then
				bettersay("You already got an orange juice.{n}What else do you need in life to be happy?")
			else
				if engine.Scene.Session:GetCounter("timesInteractedUnsuccessfullyWithVendingMachine") > 25 then
					bettersay("The RNG gods have cursed you with the worst possible luck. {~}Just keep interacting{/~}.")
				elseif engine.Scene.Session:GetCounter("timesInteractedUnsuccessfullyWithVendingMachine") > 15 then
					bettersay("This stupid vending machine full of drinks and snacks{n}doesn't want to give up and break or something. {~}Don't lose your hopes and keep insisting{/~} if you want your free prize.")
				elseif engine.Scene.Session:GetCounter("timesInteractedUnsuccessfullyWithVendingMachine") > 8 then
					bettersay("This vending machine is full of drinks and snacks,{n}but it's quite expensive. You're really unlucky, so {~}keep insisting{/~} if you want something to fall for free.")
				elseif engine.Scene.Session:GetCounter("timesInteractedUnsuccessfullyWithVendingMachine") > 3 then
					bettersay("This vending machine is full of drinks and snacks,{n}but it's quite expensive. {~}Keep insisting even more{/~} and something will eventually fall for free.")
				elseif engine.Scene.Session:GetCounter("timesInteractedUnsuccessfullyWithVendingMachine") > 2 then
					bettersay("This vending machine is full of drinks and snacks,{n}but it's quite expensive. Maybe {~}if you keep insisting even more{/~} something will eventually fall for free.")
				else
					bettersay("This vending machine is full of drinks and snacks,{n}but it's quite expensive. Maybe {~}if you keep insisting{/~} something will eventually fall for free.")
				end
				engine.Scene.Session:SetCounter("timesInteractedUnsuccessfullyWithVendingMachine", engine.Scene.Session:GetCounter("timesInteractedUnsuccessfullyWithVendingMachine") + 1)
			end
		end
	end
end

function onEnd()
	enableMovement ()
end