local drawableSprite = require "structs.drawable_sprite"
local utils = require "utils"

local boosterSurface = {}

boosterSurface.name = "FrostDepths/BoosterSurface"
boosterSurface.depth = 1999
boosterSurface.canResize = {true, false}

boosterSurface.fieldInformation = {
    speed = {
        minimumValue = 0.0
    }
}

boosterSurface.placements = {
    {
        name = "BoosterSurface",
        placementType = "rectangle",
        data = {
            width = 8,
            left = false,
            ceiling = false,
            iceMode = false,
            speed = 110,
            noRefillOnIce = true,
            notAttached = false
        }
    }
}

local fireLeftTexture = "objects/FrostDepths/boosterSurface/fireLeft00"
local fireMiddleTexture = "objects/FrostDepths/boosterSurface/fireMid00"
local fireRightTexture = "objects/FrostDepths/boosterSurface/fireRight00"

local iceLeftTexture = "objects/FrostDepths/boosterSurface/iceLeft00"
local iceMiddleTexture = "objects/FrostDepths/boosterSurface/iceMid00"
local iceRightTexture = "objects/FrostDepths/boosterSurface/iceRight00"

local function getTextures(entity)
    if entity.iceMode then
        return iceLeftTexture, iceMiddleTexture, iceRightTexture
    else
        return fireLeftTexture, fireMiddleTexture, fireRightTexture
    end
end

function boosterSurface.sprite(room, entity)
    local sprites = {}

    local left = entity.left
    local ceiling = entity.ceiling
    local width = entity.width or 8
    local tileWidth = math.floor(width / 8)
    local scale = left and 1 or -1
    local offset = left and 0 or 8

    local leftTexture, middleTexture, rightTexture = getTextures(entity)
    if not left then
        leftTexture, rightTexture = rightTexture, leftTexture
    end

    for i = 2, tileWidth - 1 do
        local middleSprite = drawableSprite.fromTexture(middleTexture, entity)

        middleSprite:addPosition((i - 1) * 8 + offset, 0)      
        middleSprite:setJustification(0.0, 0.0)
        if ceiling then
            middleSprite:setScale(1, -1)
            middleSprite:addPosition(-8, 8)
        else
            middleSprite:setScale(scale, 1)
        end

        table.insert(sprites, middleSprite)
    end

    local leftSprite = drawableSprite.fromTexture(leftTexture, entity)
    local rightSprite = drawableSprite.fromTexture(rightTexture, entity)

    leftSprite:addPosition(offset, 0)
    leftSprite:setJustification(0.0, 0.0)

    rightSprite:addPosition((tileWidth - 1) * 8 + offset, 0)   
    rightSprite:setJustification(0.0, 0.0)

    if ceiling then
        leftSprite:setScale(1, -1)
        leftSprite:addPosition(-8, 8)
        rightSprite:setScale(1, -1)
        rightSprite:addPosition(-8, 8)
    else
        leftSprite:setScale(scale, 1)
        rightSprite:setScale(scale, 1)
    end

    table.insert(sprites, leftSprite)
    table.insert(sprites, rightSprite)

    return sprites
end

function boosterSurface.rectangle(room, entity)
    return utils.rectangle(entity.x, entity.y, entity.width or 8, 8)
end

return boosterSurface
