local puffer = {}

local explodeGravityOption = {
    None = "none",
    Normal = "normal",
    Inverted = "inverted",
    Toggle = "toggle"
}

puffer.name = "FrostDepths/GravityPuffer"
puffer.depth = 0
puffer.texture = "objects/puffer/idle00"
puffer.placements = {
    {
        name = "GravityPuffer",
        data = {
            right = false,
            explodeGravityType = "none"
        }
    },
}

puffer.fieldInformation = {
    explodeGravityType = {
        options = explodeGravityOption,
        editable = false
    }
}

function puffer.scale(room, entity)
    local right = entity.right

    return right and 1 or -1, 1
end

function puffer.flip(room, entity, horizontal, vertical)
    if horizontal then
        entity.right = not entity.right
    end

    return horizontal
end

return puffer