module JackalHelperHellBooster
using ..Ahorn, Maple

@mapdef Entity "JackalHelper/HellBooster" HellBooster(x::Integer, y::Integer)


const placements = Ahorn.PlacementDict(
   "Hell Booster (Jackal Helper)" => Ahorn.EntityPlacement(
	  HellBooster,
	  "point"
   )
)

Ahorn.nodeLimits(entity::HellBooster) = 0, -1

sprite = "objects/boosterIce/boosterIce05"

function Ahorn.selection(entity::HellBooster)
    nodes = get(entity.data, "nodes", ())
    x, y = Ahorn.position(entity)

    res = Ahorn.Rectangle[Ahorn.getSpriteRectangle(sprite, x, y)]
    
    for node in nodes
        nx, ny = Int.(node)

        push!(res, Ahorn.getSpriteRectangle(sprite, nx, ny))
    end

    return res
end

function Ahorn.renderSelectedAbs(ctx::Ahorn.Cairo.CairoContext, entity::HellBooster)
    px, py = Ahorn.position(entity)

    for node in get(entity.data, "nodes", ())
        nx, ny = Int.(node)

        Ahorn.drawArrow(ctx, px, py, nx, ny, Ahorn.colors.selection_selected_fc, headLength=6)
        Ahorn.drawSprite(ctx, sprite, nx, ny)

        px, py = nx, ny
    end
end

function Ahorn.renderAbs(ctx::Ahorn.Cairo.CairoContext, entity::HellBooster, room::Maple.Room)
    x, y = Ahorn.position(entity)
    Ahorn.drawSprite(ctx, sprite, x, y, sx=-1)
end

Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::HellBooster, room::Maple.Room) = Ahorn.drawSprite(ctx, sprite, 0, 0)

end

