local drawableSprite = require("structs.drawable_sprite")

local Mother = {}

Mother.name = "LivingBreathingHelper/Mother"
Mother.depth = -12000

Mother.fieldInformation = {
    growTime = {
        minimumValue = 0
    },
    shrinkTime = {
        minimumValue = 0
    },
    angerRadius = {
        fieldType = "integer",
        minimumValue = 0
    },
    jumpSize = {
        fieldType = "integer",
        minimumValue = 0
    },
    maximumNodeCount = {
        fieldType = "integer",
        minimumValue = 0
    },
    hitboxRadius = {
        fieldType = "integer",
    }
}

Mother.placements = {
{
    name = "Mother (Default)",
	data = {
	growTime = 0.8,
	shrinkTime = 0.4,
	angerRadius = 110.0,
	jumpSize = 16.0,
	maximumNodeCount = 0.0,
	rotationSpeed = 1.0,
	hitboxRadius = 26,
	sprite = "basic",
	flag = "",
	growSound = "event:/LivingBreathingHelper/mother_grow",
	wormMode = false
	}
},
{
    name = "Mother (Spinner)",
	data = {
	growTime = 0.1,
	shrinkTime = 0.1,
	angerRadius = 9999.0,
	jumpSize = 12.0,
	maximumNodeCount = 5.0,
	rotationSpeed = 0.0,
	hitboxRadius = 8,
	sprite = "spinner",
	flag = "LBH_SpinnerGrowFlag",
	growSound = "event:/game/general/diamond_return",
	wormMode = false
	}
},
{
    name = "Mother (Worm)",
	data = {
	growTime = 0.15,
	shrinkTime = 0.0,
	angerRadius = 300.0,
	jumpSize = 16.0,
	maximumNodeCount = 8.0,
	rotationSpeed = 0.0,
	hitboxRadius = 8,
	sprite = "wormtime",
	flag = "LBH_WormGrowFlag",
	growSound = "event:/game/general/bird_land_dirt",
	wormMode = true
	}
}
}

Mother.fieldOrder = {
"x", "y", "growTime", "shrinkTime", "angerRadius", "jumpSize", "maximumNodeCount", "rotationSpeed", "hitboxRadius", "sprite", "flag", "growSound", "wormMode"
}

function Mother.texture(room, entity)
    if drawableSprite.fromTexture("objects/LivingBreathingHelper/Mother/" .. entity.sprite .. "00") ~= nil then
        return "objects/LivingBreathingHelper/Mother/" .. entity.sprite .. "00"
    else
        return "objects/LivingBreathingHelper/Mother/" .. entity.sprite
    end
end

return Mother