local monocle = require("#monocle")
local coroutineEntity = monocle.Entity()

local function badeline_appears(left_side)
  local pos_x, scale
  if left_side then
    pos_x = player.Position.X + 16
    scale = -1
  else
    pos_x = player.Position.X + 32
    scale = -1
  end
  local pos_y = player.Position.Y - 12

  badeline = celeste.BadelineDummy(vector2(pos_x, pos_y))
  badeline.Sprite.Scale = vector2(scale, 1.0)
  getLevel():Add(badeline)

  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  playSound("event:/char/badeline/maddy_split", badeline.Position)

  wait()
end

local function badeline_moves(pos_x, scale, pos_y)
  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  getLevel():Remove(badeline)

  badeline = celeste.BadelineDummy(vector2(pos_x, pos_y))
  badeline.Sprite.Scale = vector2(scale, 1.0)
  getLevel():Add(badeline)

  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  playSound("event:/char/badeline/maddy_split", badeline.Position)

  wait()
end

function onTalk()
	local level = getLevel()
	level:add(coroutineEntity)
	disableMovement()
	say("LL_ACKNOWLEDGEMENTS")
	wait()
end

function onEnd(room, wasSkipped)
	if wasSkipped then
	enableMovement()
	else
	enableMovement()
	end
end