local function badeline_appears(left_side)
  local pos_x, scale
  if left_side then
    pos_x = player.Position.X - 24
    scale = 1
  else
    pos_x = player.Position.X + 24
    scale = -1
  end
  local pos_y = player.Position.Y - 12

  badeline = celeste.BadelineDummy(vector2(pos_x, pos_y))
  badeline.Sprite.Scale = vector2(scale, 1.0)
  getLevel():Add(badeline)

  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  playSound("event:/char/badeline/maddy_split", badeline.Position)

  wait()
end

function onTalk()
	disableMovement()
	makeUnskippable()
	setFlag("scene1", true)
	walkTo(1614)
	walk(5)
	badeline_appears()
	say("LL_EXTRA_A_1")
	walk(-12)
	say("LL_EXTRA_A_2")
	walk(12)
	say("LL_EXTRA_A_3")
	walk(-12)
	say("LL_EXTRA_A_4")
	badeline:Vanish()
	wait(0.1)
end

function onEnd(room, wasSkipped)
	if wasSkipped then
	setFlag("scene1", true)
	enableMovement()
	badeline:Vanish()
	else
	setFlag("scene1", true)
	enableMovement()
	end
end