local monocle = require("#monocle")
local coroutineEntity = monocle.Entity()

local function badeline_appears(pos_x, scale, pos_y)
  badeline = celeste.BadelineDummy(vector2(pos_x, pos_y))
  badeline.Sprite.Scale = vector2(scale, 1.0)
  getLevel():Add(badeline)

  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  playSound("event:/char/badeline/maddy_split", badeline.Position)

  wait()
end

function onTalk()
	local level = getLevel()
	level:add(coroutineEntity)
	disableMovement()
	makeUnskippable()
	setFlag("scene2", true)
	coroutineEntity:add(monocle.Coroutine(level:ZoomTo(vector2(190,70), 1.35, 3)))
	walkTo(1604)
	walk(-16)
	badeline_appears(player.Position.X + 24, -1, player.Position.Y - 12)
	player.DummyAutoAnimate = false
	player.Sprite:Play("sleep")
	say("LL_EXTRA_B_1")
	coroutineEntity:add(monocle.Coroutine(level:ZoomAcross(vector2(175,80), 1.25, 3)))
	say("LL_EXTRA_B_2")
	wait(2.0)
	say("LL_EXTRA_B_3")
	player.Sprite:Play("wakeUp")
	coroutineEntity:add(monocle.Coroutine(level:ZoomBack(2.5)))
	coroutineEntity:add(monocle.Coroutine(wait(1.5)))
	say("LL_EXTRA_B_4")
	badeline:Vanish()
	wait()
end

function onEnd(room, wasSkipped)
	if wasSkipped then
	setFlag("scene2", true)
	getLevel():Remove(coroutineEntity)
	enableMovement()
	badeline:Vanish()
	else
	setFlag("scene2", true)
	getLevel():Remove(coroutineEntity)
	enableMovement()
	end
end