local monocle = require("#monocle")
local coroutineEntity = monocle.Entity()
local badeline = nil

local function badeline_appears(pos_x, scale, pos_y)
  badeline = celeste.BadelineDummy(vector2(pos_x, pos_y))
  badeline.Sprite.Scale = vector2(scale, 1.0)
  getLevel():Add(badeline)

  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  playSound("event:/char/badeline/maddy_split", badeline.Position)

  wait()
end

function onTalk()
	local level = getLevel()
	level:add(coroutineEntity)
	disableMovement()
	makeUnskippable()
	setFlag("scene3", true)
	badeline_appears(player.Position.X - 8, 1, player.Position.Y - 20)
	coroutineEntity:add(monocle.Coroutine(level:ZoomTo(vector2(150,90), 1.5, 3)))
	walkTo(6304)
	say("LL_EXTRA_C_1")
	wait(1.5)
	say("LL_EXTRA_C_2")
	walk(16)
	say("LL_EXTRA_C_3")
	run(-24)
	say("LL_EXTRA_C_4")
	coroutineEntity:add(monocle.Coroutine(runTo(6400)))
	say("LL_EXTRA_C_5")
	wait(1.5)
	coroutineEntity:add(monocle.Coroutine(level:ZoomAcross(vector2(185,90), 1.5, 0.5)))
	coroutineEntity:add(monocle.Coroutine(walkTo(6392)))
	say("LL_EXTRA_C_6")
	coroutineEntity:add(monocle.Coroutine(level:ZoomBack(1)))
	say("LL_EXTRA_C_7")
	wait()
end

function onEnd(room, wasSkipped)
	if wasSkipped then
	setFlag("scene3", true)
	getLevel():Remove(coroutineEntity)
	if badeline then
	badeline:Vanish()
	badeline = nil
	end
	setPlayerState(0)
	enableMovement()
	else
	setFlag("scene3", true)
	getLevel():Remove(coroutineEntity)
	if badeline then
	badeline:Vanish()
	badeline = nil
	end
	enableMovement()
	end
end