local monocle = require("#monocle")
local coroutineEntity = monocle.Entity()

local function badeline_appears(pos_x, scale, pos_y)
  badeline = celeste.BadelineDummy(vector2(pos_x, pos_y))
  badeline.Sprite.Scale = vector2(scale, 1.0)
  getLevel():Add(badeline)

  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  playSound("event:/char/badeline/maddy_split", badeline.Position)

  wait()
end

local function badeline_moves(pos_x, scale, pos_y)
  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  getLevel():Remove(badeline)

  badeline = celeste.BadelineDummy(vector2(pos_x, pos_y))
  badeline.Sprite.Scale = vector2(scale, 1.0)
  getLevel():Add(badeline)

  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  playSound("event:/char/badeline/maddy_split", badeline.Position)

  wait()
end

function onTalk()
	local level = getLevel()
	level:add(coroutineEntity)
	disableMovement()
	makeUnskippable()
	setFlag("scene4", true)
	badeline_appears(player.Position.X - 8, 1, player.Position.Y - 20)
	coroutineEntity:add(monocle.Coroutine(level:ZoomTo(vector2(180,90), 1.35, 3)))
	walkTo(7356)
	player.DummyAutoAnimate = false
	player.Sprite:Play("sitDown")
	say("LL_EXTRA_D_1")
	wait(0.5)
	coroutineEntity:add(monocle.Coroutine(level:ZoomAcross(vector2(220,110), 1.6, 2)))
	badeline_moves(player.Position.X + 56, -1, player.Position.Y - 8)
	badeline.Sprite:Play("spin")
	say("LL_EXTRA_D_2")
	wait(0.5)
	badeline_moves(player.Position.X + 20, -1, player.Position.Y - 8)
	badeline.Sprite:Play("fallSlow")
	wait(1.0)
	say("LL_EXTRA_D_3")
	player.Sprite:Play("wakeUp")
	wait(2.5)
	player.DummyAutoAnimate = true
	coroutineEntity:add(monocle.Coroutine(level:ZoomBack(2.5)))
	say("LL_EXTRA_D_4")
	badeline:Vanish()
	wait()
end

function onEnd(room, wasSkipped)
	if wasSkipped then
	setFlag("scene4", true)
	getLevel():Remove(coroutineEntity)
	enableMovement()
	badeline:Vanish()
	else
	setFlag("scene4", true)
	getLevel():Remove(coroutineEntity)
	enableMovement()
	end
end