local monocle = require("#monocle")
local coroutineEntity = monocle.Entity()

local function badeline_appears(pos_x, scale, pos_y)
  badeline = celeste.BadelineDummy(vector2(pos_x, pos_y))
  badeline.Sprite.Scale = vector2(scale, 1.0)
  getLevel():Add(badeline)

  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  playSound("event:/char/badeline/maddy_split", badeline.Position)

  wait()
end

local function badeline_moves(pos_x, scale, pos_y)
  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  getLevel():Remove(badeline)

  badeline = celeste.BadelineDummy(vector2(pos_x, pos_y))
  badeline.Sprite.Scale = vector2(scale, 1.0)
  getLevel():Add(badeline)

  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  playSound("event:/char/badeline/maddy_split", badeline.Position)

  wait()
end

function onTalk()
	local level = getLevel()
	level:add(coroutineEntity)
	disableMovement()
	makeUnskippable()
	setFlag("scene5", true)
	walkTo(8008)
	badeline_appears(player.Position.X + 16, 1, player.Position.Y - 12)
	coroutineEntity:add(monocle.Coroutine(level:ZoomTo(vector2(130,110), 1.35, 2)))
	say("LL_EXTRA_E_1")
	badeline_moves(player.Position.X - 8, 1, player.Position.Y - 4)
	say("LL_EXTRA_E_2")
	wait(1)
	jump()
	say("LL_EXTRA_E_3")
	badeline_moves(player.Position.X + 16, -1, player.Position.Y - 12)
	say("LL_EXTRA_E_4")
	walk(-8, true)
	say("LL_EXTRA_E_5")
	coroutineEntity:add(monocle.Coroutine(level:ZoomBack(2.5)))
	say("LL_EXTRA_E_6")
	badeline:Vanish()
	wait()
end

function onEnd(room, wasSkipped)
	if wasSkipped then
	setFlag("scene5", true)
	enableMovement()
	badeline:Vanish()
	else
	setFlag("scene5", true)
	enableMovement()
	end
end