local monocle = require("#monocle")
local coroutineEntity = monocle.Entity()

local function badeline_appears(pos_x, scale, pos_y)
  badeline = celeste.BadelineDummy(vector2(pos_x, pos_y))
  badeline.Sprite.Scale = vector2(scale, 1.0)
  getLevel():Add(badeline)

  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  playSound("event:/char/badeline/maddy_split", badeline.Position)

  wait()
end

local function badeline_moves(pos_x, scale, pos_y)
  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  getLevel():Remove(badeline)

  badeline = celeste.BadelineDummy(vector2(pos_x, pos_y))
  badeline.Sprite.Scale = vector2(scale, 1.0)
  getLevel():Add(badeline)

  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  playSound("event:/char/badeline/maddy_split", badeline.Position)

  wait()
end

function onTalk()
	local level = getLevel()
	level:add(coroutineEntity)
	disableMovement()
	makeUnskippable()
	setFlag("scene6", true)
	coroutineEntity:add(monocle.Coroutine(level:ZoomTo(vector2(210,80), 1.5, 3)))
	walkTo(10016)
	badeline_appears(player.Position.X + 24, -1, player.Position.Y - 20)
	say("LL_EXTRA_F_1")
	walk(8)
	say("LL_EXTRA_F_2")
	badeline_moves(player.Position.X + 6, -1, player.Position.Y - 4)
	jump()
	walk(-40, true)
	wait(1.5)
	walk(12)
	say("LL_EXTRA_F_3")
	coroutineEntity:add(monocle.Coroutine(level:ZoomBack(2.5)))
	say("LL_EXTRA_F_4")
	badeline:Vanish()
	wait()
end

function onEnd(room, wasSkipped)
	if wasSkipped then
	setFlag("scene6", true)
	enableMovement()
	badeline:Vanish()
	else
	setFlag("scene6", true)
	enableMovement()
	end
end