local monocle = require("#monocle")
local coroutineEntity = monocle.Entity()

local function badeline_appears(pos_x, scale, pos_y)
  badeline = celeste.BadelineDummy(vector2(pos_x, pos_y))
  badeline.Sprite.Scale = vector2(scale, 1.0)
  getLevel():Add(badeline)

  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  playSound("event:/char/badeline/maddy_split", badeline.Position)

  wait()
end

local function badeline_moves(pos_x, scale, pos_y)
  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  getLevel():Remove(badeline)

  badeline = celeste.BadelineDummy(vector2(pos_x, pos_y))
  badeline.Sprite.Scale = vector2(scale, 1.0)
  getLevel():Add(badeline)

  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  playSound("event:/char/badeline/maddy_split", badeline.Position)

  wait()
end

function onTalk()
	local level = getLevel()
	level:add(coroutineEntity)
	disableMovement()
	makeUnskippable()
	setFlag("scene7", true)
	coroutineEntity:add(monocle.Coroutine(level:ZoomTo(vector2(140,70), 1.5, 3)))
	walkTo(11228)
	player.DummyAutoAnimate = false
	player.Sprite:Play("sitDown")
	say("LL_EXTRA_G_1")
	wait(1.5)
	say("LL_EXTRA_G_2")
	wait(1.5)
	say("LL_EXTRA_G_3")
	wait(1.5)
	say("LL_EXTRA_G_4")
	player.Sprite:Play("wakeUp")
	wait(2.5)
	player.DummyAutoAnimate = true
	coroutineEntity:add(monocle.Coroutine(level:ZoomBack(2.5)))
	say("LL_EXTRA_G_5")
	wait()
end

function onEnd(room, wasSkipped)
	if wasSkipped then
	setFlag("scene7", true)
	enableMovement()
	badeline:Vanish()
	else
	setFlag("scene7", true)
	enableMovement()
	end
end