local monocle = require("#monocle")
local coroutineEntity = monocle.Entity()

local function badeline_appears(pos_x, scale, pos_y)
  badeline = celeste.BadelineDummy(vector2(pos_x, pos_y))
  badeline.Sprite.Scale = vector2(scale, 1.0)
  getLevel():Add(badeline)

  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  playSound("event:/char/badeline/maddy_split", badeline.Position)

  wait()
end

local function badeline_moves(pos_x, scale, pos_y)
  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  getLevel():Remove(badeline)

  badeline = celeste.BadelineDummy(vector2(pos_x, pos_y))
  badeline.Sprite.Scale = vector2(scale, 1.0)
  getLevel():Add(badeline)

  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  playSound("event:/char/badeline/maddy_split", badeline.Position)

  wait()
end

function onTalk()
	local level = getLevel()
	level:add(coroutineEntity)
	local extraDialog = getFlag("scene7")
	disableMovement()
	makeUnskippable()
	setFlag("scene8", true)
	coroutineEntity:add(monocle.Coroutine(level:ZoomTo(vector2(160,90), 1.2, 3)))
	walkTo(13412)
	jump()
	walkTo(13450)
	player.DummyAutoAnimate = false
	player.Sprite:Play("sitDown")
	say("LL_EXTRA_H_1")
	wait(1.5)
	say("LL_EXTRA_H_2")
	wait(1)
	if extraDialog then
	  say("LL_EXTRA_H_EXTRA_1")
	end
	player.Sprite:Play("wakeUp")
	wait(2.5)
	player.DummyAutoAnimate = true
	coroutineEntity:add(monocle.Coroutine(level:ZoomBack(2.5)))
	say("LL_EXTRA_H_3")
	badeline:Vanish()
	wait()
end

function onEnd(room, wasSkipped)
	if wasSkipped then
	setFlag("scene8", true)
	enableMovement()
	badeline:Vanish()
	else
	setFlag("scene8", true)
	enableMovement()
	end
end