local monocle = require("#monocle")
local coroutineEntity = monocle.Entity()

local function badeline_appears(pos_x, scale, pos_y)
  badeline = celeste.BadelineDummy(vector2(pos_x, pos_y))
  badeline.Sprite.Scale = vector2(scale, 1.0)
  getLevel():Add(badeline)

  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  playSound("event:/char/badeline/maddy_split", badeline.Position)

  wait()
end

local function badeline_moves(pos_x, scale, pos_y)
  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  getLevel():Remove(badeline)

  badeline = celeste.BadelineDummy(vector2(pos_x, pos_y))
  badeline.Sprite.Scale = vector2(scale, 1.0)
  getLevel():Add(badeline)

  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  playSound("event:/char/badeline/maddy_split", badeline.Position)

  wait()
end

function onTalk()
	getLevel():add(coroutineEntity)
	local extraDialog = getFlag("scene6")
	disableMovement()
	makeUnskippable()
	setFlag("scene9", true)
	walkTo(17500)
	player.DummyAutoAnimate = false
	player.Sprite:Play("sitDown")
	badeline_appears(player.Position.X + 56, -1, player.Position.Y - 28)
	say("LL_EXTRA_I_1")
	coroutineEntity:add(monocle.Coroutine(celeste.CutsceneEntity.CameraTo(vector2(17432, -500), 10)))
	wait(5.5)
	player.Sprite:Play("wakeUp")
	wait(2.5)
	player.DummyAutoAnimate = true
	say("LL_EXTRA_I_2")
	if extraDialog then
	  say("LL_EXTRA_I_EXTRA_1")
	end
	wait(1)
end

function onEnd(room, wasSkipped)
	if wasSkipped then
	setFlag("scene9", true)
	getLevel():Remove(coroutineEntity)
	enableMovement()
	badeline:Vanish()
	else
	setFlag("scene9", true)
	getLevel():Remove(coroutineEntity)
	enableMovement()
	badeline:Vanish()
	end
end