local monocle = require("#monocle")
local coroutineEntity = monocle.Entity()

local function badeline_appears(pos_x, scale, pos_y)
  badeline = celeste.BadelineDummy(vector2(pos_x, pos_y))
  badeline.Sprite.Scale = vector2(scale, 1.0)
  getLevel():Add(badeline)

  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  playSound("event:/char/badeline/maddy_split", badeline.Position)

  wait()
end

local function badeline_moves(pos_x, scale, pos_y)
  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  getLevel():Remove(badeline)

  badeline = celeste.BadelineDummy(vector2(pos_x, pos_y))
  badeline.Sprite.Scale = vector2(scale, 1.0)
  getLevel():Add(badeline)

  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  playSound("event:/char/badeline/maddy_split", badeline.Position)

  wait()
end

function onTalk()
	local level = getLevel()
	level:add(coroutineEntity)
	disableMovement()
	makeUnskippable()
	setFlag("scene10", true)
	coroutineEntity:add(monocle.Coroutine(celeste.CutsceneEntity.CameraTo(vector2(21555, 1249), 0.5)))
	coroutineEntity:add(monocle.Coroutine(level:ZoomTo(vector2(150,90), 1.5, 2)))
	walkTo(21684)
	player.DummyAutoAnimate = false
	player.Sprite:Play("sitDown")
	badeline_appears(player.Position.X + 16, -1, player.Position.Y - 20)
	say("LL_EXTRA_J_1")
	wait(2)
	say("LL_EXTRA_J_2")
	coroutineEntity:add(monocle.Coroutine(level:ZoomBack(3)))
	say("LL_EXTRA_J_3")
	player.Sprite:Play("wakeUp")
	wait(2.5)
	player.DummyAutoAnimate = true
	badeline:Vanish()
	wait()
end

function onEnd(room, wasSkipped)
	if wasSkipped then
	setFlag("scene10", true)
	getLevel():Remove(coroutineEntity)
	enableMovement()
	badeline:Vanish()
	else
	setFlag("scene10", true)
	getLevel():Remove(coroutineEntity)
	enableMovement()
	end
end