local monocle = require("#monocle")
local coroutineEntity = monocle.Entity()

local function badeline_appears(pos_x, scale, pos_y)
  badeline = celeste.BadelineDummy(vector2(pos_x, pos_y))
  badeline.Sprite.Scale = vector2(scale, 1.0)
  getLevel():Add(badeline)

  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  playSound("event:/char/badeline/maddy_split", badeline.Position)

  wait()
end

local function badeline_moves(pos_x, scale, pos_y)
  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  getLevel():Remove(badeline)

  badeline = celeste.BadelineDummy(vector2(pos_x, pos_y))
  badeline.Sprite.Scale = vector2(scale, 1.0)
  getLevel():Add(badeline)

  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  playSound("event:/char/badeline/maddy_split", badeline.Position)

  wait()
end


function onTalk()
	local level = getLevel()
	level:add(coroutineEntity)
	disableMovement()
	makeUnskippable()
	setFlag("scene11", true)
	walkTo(21212)
	walk(12)
	player.DummyAutoAnimate = false
	player.Sprite:Play("sitDown")
	badeline_appears(player.Position.X + 40, -1, player.Position.Y - 12)
	say("LL_EXTRA_K_1")
	coroutineEntity:add(monocle.Coroutine(level:ZoomTo(vector2(170,90), 1.2, 0.4)))
	say("LL_EXTRA_K_2")
	coroutineEntity:add(monocle.Coroutine(level:ZoomAcross(vector2(180,90), 1.4, 0.4)))
	say("LL_EXTRA_K_3")
	coroutineEntity:add(monocle.Coroutine(level:ZoomAcross(vector2(190,90), 1.6, 0.4)))
	setFlag("tentaclesC", true)
	playSound("event:/game/06_reflection/badeline_freakout_1")
	say("LL_EXTRA_K_4")
	setFlag("tentaclesC", false)
	say("LL_EXTRA_K_5")
	coroutineEntity:add(monocle.Coroutine(level:ZoomBack(2.5)))
	player.Sprite:Play("wakeUp")
	wait(2.5)
	player.DummyAutoAnimate = true
	badeline:Vanish()
	wait()
end

function onEnd(room, wasSkipped)
	if wasSkipped then
	setFlag("scene11", true)
	enableMovement()
	badeline:Vanish()
	else
	setFlag("scene11", true)
	enableMovement()
	end
end