local monocle = require("#monocle")
local coroutineEntity = monocle.Entity()

local function badeline_appears(left_side)
  local pos_x, scale
  if left_side then
    pos_x = player.Position.X - 18
    scale = 1
  else
    pos_x = player.Position.X + 18
    scale = -1
  end
  local pos_y = player.Position.Y - 8

  badeline = celeste.BadelineDummy(vector2(pos_x, pos_y))
  badeline.Sprite.Scale = vector2(scale, 1.0)
  getLevel():Add(badeline)

  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  playSound("event:/char/badeline/maddy_split", badeline.Position)

  wait()
end

local function badeline_vanishes()
  badeline:Vanish()
  Input.Rumble(getEnum("Celeste.RumbleStrength", "Medium"), getEnum("Celeste.RumbleLength", "Medium"))
  badeline = nil

  wait()
end

function onBegin()
	local level = getLevel()
	level:add(coroutineEntity)
	coroutineEntity:add(monocle.Coroutine(celeste.CutsceneEntity.CameraTo(vector2(-281, -34), 0.5)))
	coroutineEntity:add(monocle.Coroutine(level:ZoomTo(vector2(135,100), 1.2, 3)))
	disableMovement()
	say("LL_CUTSCENE_A_1")
	badeline_appears()
	walk(-8, true)
	say("LL_CUTSCENE_A_2")
	coroutineEntity:add(monocle.Coroutine(level:ZoomBack(1)))
	say("LL_CUTSCENE_A_3")
	badeline_vanishes()
	level:ResetZoom()
end

function onEnd(room, wasSkipped)
	if wasSkipped then
	enableMovement()
	badeline_vanishes()
	level:ResetZoom()
	else
	enableMovement()
	level:ResetZoom()
	end
end